/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.BottomConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BottomCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.bottom";
    private final PlayerLanguageManager langManager;
    private final BottomConfig config;
    private final CommandDataStorage dataStorage;

    public BottomCommand(PlayerLanguageManager langManager, BottomConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.bottom.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.bottom.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        Location loc = player.getLocation();
        boolean found = false;
        for (int y = 0; y < loc.getBlockY(); ++y) {
            Location check = new Location(loc.getWorld(), loc.getX(), (double)y, loc.getZ());
            if (check.getBlock().getType() == Material.AIR || check.clone().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR) continue;
            player.teleport(check);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.bottom.success", "<green>Teleported to bottom! <gray>(Y: {y})", LanguageManager.ComponentPlaceholder.of("{y}", y)));
            found = true;
            break;
        }
        if (!found) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.bottom.no-safe-ground", "<red>No safe ground below!", new LanguageManager.ComponentPlaceholder[0]));
        }
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "bottom", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "bottom", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "bottom", "last_used", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }
}

