/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import net.kyori.adventure.text.Component;
import net.lunark.io.commands.config.BroadcastConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BroadcastCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.broadcast";
    private final PlayerLanguageManager langManager;
    private final BroadcastConfig config;

    public BroadcastCommand(PlayerLanguageManager langManager, BroadcastConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.broadcast.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.broadcast.usage", "<red>Usage: /broadcast <message>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String message = String.join((CharSequence)" ", args);
        Component broadcastMessage = this.langManager.getMessageFor(null, "commands.broadcast.format", "<blue>[Server] <white>{message}", LanguageManager.ComponentPlaceholder.of("{message}", message));
        Bukkit.broadcast((Component)broadcastMessage);
        return true;
    }
}

