/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.CelebrateConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CelebrateCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.celebrate";
    private static final String PERMISSION_OTHERS = "serveressentials.command.celebrate.others";
    private final PlayerLanguageManager langManager;
    private final CelebrateConfig config;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;

    public CelebrateCommand(PlayerLanguageManager langManager, CelebrateConfig config, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Location loc;
        World world;
        Player target;
        if (args.length > 2) {
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.celebrate.usage", "Usage: /celebrate [player] [-s]", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        boolean silent = false;
        String targetName = null;
        for (String arg : args) {
            if ("-s".equalsIgnoreCase(arg)) {
                silent = true;
                continue;
            }
            if (targetName != null) continue;
            targetName = arg;
        }
        boolean isSelf = false;
        if (targetName == null) {
            if (!(sender instanceof Player)) {
                Component message = this.langManager.getMessageFor(null, "commands.celebrate.only-player", "Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]);
                sender.sendMessage(message.toString());
                return true;
            }
            Player player = (Player)sender;
            target = player;
            isSelf = true;
        } else {
            target = Bukkit.getPlayerExact(targetName);
            if (target == null || !target.isOnline()) {
                Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.celebrate.target-not-found", "Player not found.", LanguageManager.ComponentPlaceholder.of("{target}", targetName));
                sender.sendMessage(message.toString());
                return true;
            }
        }
        if (isSelf) {
            if (!sender.hasPermission(PERMISSION)) {
                Component message = this.langManager.getMessageFor(target, "commands.celebrate.no-permission", "You need permission {permission}!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
                target.sendMessage(message);
                return true;
            }
        } else if (!sender.hasPermission(PERMISSION_OTHERS)) {
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.celebrate.no-permission-others", "You need permission {permission}!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_OTHERS));
            sender.sendMessage(message.toString());
            return true;
        }
        if ((world = (loc = target.getLocation()).getWorld()) == null) {
            return true;
        }
        FireworkEffect effect = this.config.getEffect();
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Firework fw = (Firework)world.spawnEntity(loc, EntityType.FIREWORK_ROCKET);
            FireworkMeta meta = fw.getFireworkMeta();
            meta.addEffect(effect);
            meta.setPower(1);
            fw.setFireworkMeta(meta);
        });
        if (!silent) {
            String targetNameForMessage = isSelf ? this.langManager.getMessageFor(target, "commands.celebrate.self-name", "yourself", new LanguageManager.ComponentPlaceholder[0]).toString() : target.getName();
            String messageKey = isSelf ? "commands.celebrate.message" : "commands.celebrate.message-other";
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, messageKey, "Celebration!", LanguageManager.ComponentPlaceholder.of("{target}", targetNameForMessage));
            sender.sendMessage(message.toString());
        }
        this.trackUsage(target.getUniqueId(), isSelf ? "self" : "other", 1);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            String prefix = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(prefix)).collect(Collectors.toList());
        }
        if (args.length == 2 && "-s".startsWith(args[1].toLowerCase())) {
            return List.of("-s");
        }
        return List.of();
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "celebrate", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "celebrate", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "celebrate", "last_type", type);
            this.dataStorage.setState(playerId, "celebrate", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

