/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.lunark.io.commands.config.CoinFlipConfig;
import net.lunark.io.economy.ServerEssentialsEconomy;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class CoinFlipCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.coinflip";
    private static final String COMMAND_NAME = "coinflip";
    private static final List<String> SUGGESTED_AMOUNTS = Arrays.asList("10", "50", "100", "500", "1000");
    private final PlayerLanguageManager langManager;
    private final CoinFlipConfig config;
    private final ServerEssentialsEconomy economy;
    private final Random random;

    public CoinFlipCommand(PlayerLanguageManager langManager, CoinFlipConfig config, ServerEssentialsEconomy economy) {
        this.langManager = langManager;
        this.config = config;
        this.economy = economy;
        this.random = new Random();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.coinflip.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.coinflip.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.coinflip.usage", "<yellow>Usage: <white>{usage}", LanguageManager.ComponentPlaceholder.of("{usage}", "/" + label + " <amount>")));
            return true;
        }
        try {
            amount = Double.parseDouble(args[0]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.coinflip.invalid-amount", "<red>Invalid amount: <white>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", args[0])));
            return true;
        }
        if (amount <= 0.0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.coinflip.positive-amount", "<red>Amount must be positive!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        double balance = this.economy.getBalance((OfflinePlayer)player);
        if (balance < amount) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.coinflip.not-enough", "<red>You don't have enough money! You need <yellow>{needed}</yellow>, you have <green>{balance}", LanguageManager.ComponentPlaceholder.of("{needed}", this.economy.format(amount)), LanguageManager.ComponentPlaceholder.of("{balance}", this.economy.format(balance))));
            return true;
        }
        boolean win = this.random.nextBoolean();
        if (win) {
            this.economy.depositPlayer((OfflinePlayer)player, amount);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.coinflip.win", "<green>You won! You received <gold>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economy.format(amount))));
        } else {
            this.economy.withdrawPlayer((OfflinePlayer)player, amount);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.coinflip.lose", "<red>You lost! You lost <gold>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economy.format(amount))));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission(PERMISSION)) {
            return List.of();
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            for (String s : SUGGESTED_AMOUNTS) {
                if (!s.startsWith(input)) continue;
                completions.add(s);
            }
            return completions;
        }
        return List.of();
    }
}

