/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.CompassConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class CompassCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.compass";
    private final PlayerLanguageManager langManager;
    private final CompassConfig config;
    private final CommandDataStorage dataStorage;

    public CompassCommand(PlayerLanguageManager langManager, CompassConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.compass.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.compass.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        float yaw = player.getLocation().getYaw();
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        String direction = (double)yaw >= 337.5 || (double)yaw < 22.5 ? "North" : ((double)yaw < 67.5 ? "North-East" : ((double)yaw < 112.5 ? "East" : ((double)yaw < 157.5 ? "South-East" : ((double)yaw < 202.5 ? "South" : ((double)yaw < 247.5 ? "South-West" : ((double)yaw < 292.5 ? "West" : "North-West"))))));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.compass.facing", "<green>You are facing <gold><bold>{direction}", LanguageManager.ComponentPlaceholder.of("{direction}", direction)));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "compass", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "compass", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "compass", "last_direction", direction);
        });
        return true;
    }
}

