/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.config.EcoConfig;
import net.lunark.io.economy.ServerEssentialsEconomy;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class EcoCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.eco";
    private static final String COMMAND_NAME = "eco";
    private final PlayerLanguageManager langManager;
    private final EcoConfig config;
    private final ServerEssentialsEconomy economy;

    public EcoCommand(PlayerLanguageManager langManager, EcoConfig config, ServerEssentialsEconomy economy) {
        this.langManager = langManager;
        this.config = config;
        this.economy = economy;
    }

    private OfflinePlayer getTargetPlayer(String name) {
        Player online = Bukkit.getPlayer((String)name);
        return online != null ? online : Bukkit.getOfflinePlayerIfCached((String)name);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!sender.hasPermission(PERMISSION)) {
            Player p;
            Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.eco.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            sender.sendMessage(message);
            return true;
        }
        if (args.length < 2) {
            Player p;
            Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.eco.usage", "<yellow>Usage: <white>{usage}", LanguageManager.ComponentPlaceholder.of("{usage}", "/eco <give|take|reset> <player> [amount]"));
            sender.sendMessage(message);
            return true;
        }
        OfflinePlayer target = this.getTargetPlayer(args[1]);
        if (target == null) {
            Player p;
            Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.eco.player-not-found", "<red>Player not found: <white>{player}", LanguageManager.ComponentPlaceholder.of("{player}", args[1]));
            sender.sendMessage(message);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "give": {
                this.handleGive(sender, target, args, label);
                break;
            }
            case "take": {
                this.handleTake(sender, target, args, label);
                break;
            }
            case "reset": {
                this.handleReset(sender, target);
                break;
            }
            default: {
                Player p;
                Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.eco.unknown-subcommand", "<red>Unknown subcommand: <white>{sub}", LanguageManager.ComponentPlaceholder.of("{sub}", sub));
                sender.sendMessage(message);
            }
        }
        return true;
    }

    private void handleGive(CommandSender sender, OfflinePlayer target, String[] args, String label) {
        Player p;
        if (args.length < 3) {
            Player p2;
            Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p2 = (Player)sender) : null), "commands.eco.give-usage", "<yellow>Usage: <white>{usage}", LanguageManager.ComponentPlaceholder.of("{usage}", "/" + label + " give <player> <amount>"));
            sender.sendMessage(message);
            return;
        }
        double amount = this.parseAmount(args[2], sender);
        if (amount < 0.0) {
            return;
        }
        this.economy.depositPlayer(target, amount);
        Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.eco.give-success", "<green>Gave <white>{amount} <green>to <white>{player}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economy.format(amount)), LanguageManager.ComponentPlaceholder.of("{player}", target.getName()));
        sender.sendMessage(message);
    }

    private void handleTake(CommandSender sender, OfflinePlayer target, String[] args, String label) {
        Player p;
        if (args.length < 3) {
            Player p2;
            Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p2 = (Player)sender) : null), "commands.eco.take-usage", "<yellow>Usage: <white>{usage}", LanguageManager.ComponentPlaceholder.of("{usage}", "/" + label + " take <player> <amount>"));
            sender.sendMessage(message);
            return;
        }
        double amount = this.parseAmount(args[2], sender);
        if (amount < 0.0) {
            return;
        }
        this.economy.withdrawPlayer(target, amount);
        Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.eco.take-success", "<green>Took <white>{amount} <green>from <white>{player}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economy.format(amount)), LanguageManager.ComponentPlaceholder.of("{player}", target.getName()));
        sender.sendMessage(message);
    }

    private void handleReset(CommandSender sender, OfflinePlayer target) {
        Player p;
        double bal = this.economy.getBalance(target);
        this.economy.withdrawPlayer(target, bal);
        Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.eco.reset-success", "<green>Reset balance for <white>{player}", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()));
        sender.sendMessage(message);
    }

    private double parseAmount(String input, CommandSender sender) {
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            Player p;
            Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.eco.invalid-amount", "<red>Invalid amount: <white>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", input));
            sender.sendMessage(message);
            return -1.0;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block4: {
            block3: {
                if (!sender.hasPermission(PERMISSION)) {
                    return List.of();
                }
                completions = new ArrayList<String>();
                if (args.length != 1) break block3;
                String input = args[0].toLowerCase();
                for (String s : List.of("give", "take", "reset")) {
                    if (!s.startsWith(input)) continue;
                    completions.add(s);
                }
                break block4;
            }
            if (args.length != 2) break block4;
            String input = args[1].toLowerCase();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(input)) continue;
                completions.add(p.getName());
            }
        }
        return completions;
    }
}

