/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.FeedConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class FeedCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.feed";
    private static final String PERMISSION_OTHERS = "serveressentials.command.feed.others";
    private final PlayerLanguageManager langManager;
    private final FeedConfig config;
    private final CommandDataStorage dataStorage;

    public FeedCommand(PlayerLanguageManager langManager, FeedConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player target;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.feed.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.feed.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            target = player;
        } else if (args.length == 1) {
            if (!player.hasPermission(PERMISSION_OTHERS)) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.feed.no-permission-others", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_OTHERS)));
                return true;
            }
            target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.feed.player-not-found", "<red>Player <yellow>{target}</yellow> not found.", LanguageManager.ComponentPlaceholder.of("{target}", args[0])));
                return true;
            }
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.feed.usage", "<red>Usage: <white>/feed [player]", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        target.setFoodLevel(this.config.foodLevel());
        target.setSaturation((float)this.config.saturation());
        if (target.equals((Object)player)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.feed.fed-self", "<green>\u2713 You have been fed to full!", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.feed.fed-other", "<green>\u2713 You fed <yellow>{target}</yellow> to full!", LanguageManager.ComponentPlaceholder.of("{target}", target.getName())));
            target.sendMessage(this.langManager.getMessageFor(target, "commands.feed.fed-by-other", "<green>\u2713 You were fed to full by <yellow>{sender}</yellow>!", LanguageManager.ComponentPlaceholder.of("{sender}", player.getName())));
        }
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "feed", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "feed", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "feed", "last_type", target.equals((Object)player) ? "self" : "other");
            this.dataStorage.setState(playerId, "feed", "last_target", target.getUniqueId().toString());
        });
        return true;
    }
}

