/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.GlowConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class GlowCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.glow";
    private final PlayerLanguageManager langManager;
    private final GlowConfig config;
    private final CommandDataStorage dataStorage;

    public GlowCommand(PlayerLanguageManager langManager, GlowConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            Component message = this.langManager.getMessageFor(null, "commands.glow.only-player", "Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(player, "commands.glow.no-permission", "You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            player.sendMessage(message);
            return true;
        }
        if (args.length > 0) {
            Component message = this.langManager.getMessageFor(player, "commands.glow.usage", "Usage: /glow", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(message);
            return true;
        }
        if (player.isGlowing()) {
            player.setGlowing(false);
            Component message = this.langManager.getMessageFor(player, "commands.glow.disabled", "Glow disabled.", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(message);
        } else {
            player.setGlowing(true);
            Component message = this.langManager.getMessageFor(player, "commands.glow.enabled", "Glow enabled.", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(message);
        }
        this.trackUsage(player.getUniqueId(), "toggle", 1);
        return true;
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "glow", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "glow", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "glow", "last_type", type);
            this.dataStorage.setState(playerId, "glow", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

