/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.GrindstoneConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class GrindstoneCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.grindstone";
    private final PlayerLanguageManager langManager;
    private final GrindstoneConfig config;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;

    public GrindstoneCommand(PlayerLanguageManager langManager, GrindstoneConfig config, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.grindstone.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.grindstone.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        player.openGrindstone(null, true);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.grindstone.opened", "<green>Grindstone opened!", new LanguageManager.ComponentPlaceholder[0]));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "grindstone", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "grindstone", "usage_count", String.valueOf(count + 1));
        });
        return true;
    }
}

