/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.lunark.io.commands.config.InventorySortConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class InventorySortCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.inventorysort";
    private final PlayerLanguageManager langManager;
    private final InventorySortConfig config;

    public InventorySortCommand(PlayerLanguageManager langManager, InventorySortConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.inventorysort.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.inventorysort.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        this.sortInventory(player);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.inventorysort.success", "<green>Your inventory has been stacked and sorted!", new LanguageManager.ComponentPlaceholder[0]));
        return true;
    }

    private void sortInventory(Player player) {
        int i;
        ItemStack[] contents = player.getInventory().getContents();
        HashMap<Material, Integer> itemCounts = new HashMap<Material, Integer>();
        for (i = 0; i < 36; ++i) {
            ItemStack item = contents[i];
            if (item == null || item.getType().isAir()) continue;
            itemCounts.put(item.getType(), itemCounts.getOrDefault(item.getType(), 0) + item.getAmount());
        }
        for (i = 0; i < 36; ++i) {
            player.getInventory().setItem(i, null);
        }
        List sortedMaterials = itemCounts.keySet().stream().sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList());
        int slot = 0;
        for (Material mat : sortedMaterials) {
            int stackSize;
            int maxStack = mat.getMaxStackSize();
            for (int total = ((Integer)itemCounts.get(mat)).intValue(); total > 0 && slot < 36; total -= stackSize) {
                stackSize = Math.min(total, maxStack);
                player.getInventory().setItem(slot++, new ItemStack(mat, stackSize));
            }
        }
    }
}

