/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.LightningConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class LightningCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.lightning";
    private final PlayerLanguageManager langManager;
    private final LightningConfig config;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;

    public LightningCommand(PlayerLanguageManager langManager, LightningConfig config, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player target;
        if (args.length > 2) {
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.lightning.usage", "Usage: /lightning [player] [-s]", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        ArrayList<String> argv = new ArrayList<String>(List.of(args));
        boolean silent = argv.remove("-s");
        String targetName = argv.isEmpty() ? null : (String)argv.get(0);
        boolean isSelf = false;
        if (targetName == null) {
            if (!(sender instanceof Player)) {
                Component message = this.langManager.getMessageFor(null, "commands.lightning.only-player", "Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]);
                sender.sendMessage(message.toString());
                return true;
            }
            Player player = (Player)sender;
            target = player;
            isSelf = true;
        } else {
            target = sender.getServer().getPlayer(targetName);
            if (target == null || !target.isOnline()) {
                Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.lightning.target-not-found", "Player not found.", LanguageManager.ComponentPlaceholder.of("{target}", targetName));
                sender.sendMessage(message.toString());
                return true;
            }
        }
        if (!sender.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.lightning.no-permission", "You need permission {permission}!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            sender.sendMessage(message.toString());
            return true;
        }
        Location loc = target.getLocation();
        World world = loc.getWorld();
        if (world == null) {
            return true;
        }
        Bukkit.getScheduler().runTask(this.plugin, () -> world.strikeLightning(loc));
        if (!silent) {
            String messageKey = isSelf ? "commands.lightning.struck-self" : "commands.lightning.struck-other";
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, messageKey, isSelf ? "Lightning struck!" : "Lightning struck {target}!", LanguageManager.ComponentPlaceholder.of("{target}", target.getName()));
            sender.sendMessage(message.toString());
        }
        this.trackUsage(target.getUniqueId(), isSelf ? "self" : "other", 1);
        return true;
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "lightning", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "lightning", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "lightning", "last_type", type);
            this.dataStorage.setState(playerId, "lightning", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

