/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.config.MagnetConfig;
import net.lunark.io.commands.impl.MagnetStorage;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class MagnetCommand
implements CommandExecutor {
    private static final String PERMISSION_NODE = "serveressentials.command.magnet";
    private final PlayerLanguageManager langManager;
    private final MagnetConfig config;
    private final MagnetStorage storage;

    public MagnetCommand(PlayerLanguageManager langManager, MagnetConfig config, MagnetStorage storage) {
        this.langManager = langManager;
        this.config = config;
        this.storage = storage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.magnet.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_NODE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.magnet.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_NODE)));
            return true;
        }
        boolean currentlyEnabled = this.storage.isEnabled(player);
        CompletableFuture<Void> future = currentlyEnabled ? this.storage.disableMagnet(player) : this.storage.enableMagnet(player);
        ((CompletableFuture)future.thenRun(() -> {
            boolean nowEnabled = this.storage.isEnabled(player);
            if (nowEnabled) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.magnet.toggle-on", "<green>Magnet mode enabled. Items within {radius} blocks will be pulled to you.", LanguageManager.ComponentPlaceholder.of("{radius}", String.format("%.1f", this.config.radius))));
            } else {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.magnet.toggle-off", "<red>Magnet mode disabled.", new LanguageManager.ComponentPlaceholder[0]));
            }
        })).exceptionally(ex -> {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.magnet.error", "<red>Failed to toggle magnet: {error}", LanguageManager.ComponentPlaceholder.of("{error}", ex.getMessage())));
            return null;
        });
        return true;
    }
}

