/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.config.NearConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class NearCommand
implements CommandExecutor {
    private static final String PERMISSION_NODE = "serveressentials.command.near";
    private final PlayerLanguageManager langManager;
    private final NearConfig config;

    public NearCommand(PlayerLanguageManager langManager, NearConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.near.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_NODE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.near.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_NODE)));
            return true;
        }
        Location loc = player.getLocation();
        ArrayList<Component> nearbyPlayers = new ArrayList<Component>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            double distance;
            if (p.equals((Object)player) || !((distance = p.getLocation().distance(loc)) <= (double)this.config.maxDistance)) continue;
            nearbyPlayers.add(this.langManager.getMessageFor(player, "commands.near.entry", "<yellow>- {name} <gray>({distance} blocks)", LanguageManager.ComponentPlaceholder.of("{name}", p.getName()), LanguageManager.ComponentPlaceholder.of("{distance}", String.valueOf((int)distance))));
        }
        if (nearbyPlayers.isEmpty()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.near.none", "<red>No players are nearby.", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.near.header", "<green>Players near you:", new LanguageManager.ComponentPlaceholder[0]));
            nearbyPlayers.forEach(arg_0 -> player.sendMessage(arg_0));
        }
        return true;
    }
}

