/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.commands.config.RenameConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class RenameItemCommand
implements CommandExecutor {
    private static final String PERMISSION_NODE = "serveressentials.command.rename";
    private final PlayerLanguageManager langManager;
    private final RenameConfig config;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public RenameItemCommand(PlayerLanguageManager langManager, RenameConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.rename.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_NODE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rename.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_NODE)));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rename.usage", "<red>Usage: /rename <name>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rename.no-item", "<red>You're not holding an item.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rename.no-meta", "<red>Could not get item meta.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String input = String.join((CharSequence)" ", args);
        if (input.length() > this.config.maxNameLength) {
            input = input.substring(0, this.config.maxNameLength);
        }
        TextComponent displayName = this.config.allowColorCodes ? this.miniMessage.deserialize(input) : Component.text(input);
        meta.displayName((Component)displayName);
        item.setItemMeta(meta);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.rename.renamed", "<green>Item renamed to: <white>{item}", LanguageManager.ComponentPlaceholder.of("{item}", input)));
        return true;
    }
}

