/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.RepairConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class RepairCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.repair";
    private final PlayerLanguageManager langManager;
    private final RepairConfig config;
    private final CommandDataStorage dataStorage;

    public RepairCommand(PlayerLanguageManager langManager, RepairConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ItemMeta itemMeta;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.repair.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.repair.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.repair.no-item", "<red>You must hold an item in your main hand to repair it.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!item.hasItemMeta() || !((itemMeta = item.getItemMeta()) instanceof Damageable)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.repair.cannot-repair", "<red>This item cannot be repaired.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Damageable damageable = (Damageable)itemMeta;
        if (damageable.getDamage() == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.repair.already-full", "<yellow>This item is already at full durability.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        damageable.setDamage(0);
        item.setItemMeta((ItemMeta)damageable);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.repair.success", "<green>\u2713 Item has been fully repaired!", new LanguageManager.ComponentPlaceholder[0]));
        this.trackUsage(player.getUniqueId(), item.getType().toString(), true);
        if (this.config.playSound()) {
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
        }
        return true;
    }

    private void trackUsage(UUID playerId, String itemType, boolean success) {
        this.dataStorage.getState(playerId, "repair", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "repair", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "repair", "last_item", itemType);
            this.dataStorage.setState(playerId, "repair", "last_success", String.valueOf(success));
        });
    }
}

