/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.config.RulesConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.rules.RulesGUI;
import net.lunark.io.rules.RulesStorage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class RulesCommand
implements CommandExecutor {
    private final PlayerLanguageManager langManager;
    private final RulesConfig config;
    private final RulesStorage storage;
    private final Plugin plugin;

    public RulesCommand(PlayerLanguageManager langManager, RulesConfig config, RulesStorage storage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.storage = storage;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String action;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.rules.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(this.config.permission())) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", this.config.permission())));
            return true;
        }
        if (args.length == 0) {
            new RulesGUI(this.langManager, this.storage, this.config, this.plugin).showRules(player);
            return true;
        }
        switch (action = args[0].toLowerCase()) {
            case "accept": {
                this.handleAccept(player);
                break;
            }
            case "reload": {
                this.handleReload(player);
                break;
            }
            default: {
                this.showUsage(player);
            }
        }
        return true;
    }

    private void handleAccept(Player player) {
        if (player.hasMetadata("accepting_rules")) {
            return;
        }
        player.setMetadata("accepting_rules", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        ((CompletableFuture)this.storage.getLatestVersion().thenCompose(version -> {
            if (version == 0) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.no-rules", "<red>No rules are currently configured.", new LanguageManager.ComponentPlaceholder[0]));
                return CompletableFuture.completedFuture(null);
            }
            return this.storage.hasAcceptedRules(player.getUniqueId()).thenCompose(accepted -> {
                if (accepted.booleanValue()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.already-accepted", "<yellow>You have already accepted the latest rules.", new LanguageManager.ComponentPlaceholder[0]));
                    return CompletableFuture.completedFuture(null);
                }
                return this.storage.acceptRules(player.getUniqueId(), (int)version).thenAccept(v -> {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.accept-success", "<green>You have successfully accepted the rules!", new LanguageManager.ComponentPlaceholder[0]));
                    player.removeMetadata("accepting_rules", this.plugin);
                });
            });
        })).exceptionally(ex -> {
            player.removeMetadata("accepting_rules", this.plugin);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.error", "<red>An error occurred: {error}", LanguageManager.ComponentPlaceholder.of("{error}", ex.getMessage())));
            this.plugin.getLogger().warning("Error in /rules accept for " + player.getName() + ": " + ex.getMessage());
            return null;
        });
    }

    private void handleReload(Player player) {
        if (!player.hasPermission(this.config.reloadPermission())) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", this.config.reloadPermission())));
            return;
        }
        ((CompletableFuture)this.storage.reloadRulesFromConfig().thenAccept(v -> player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.reload-success", "<green>Rules reloaded successfully!", new LanguageManager.ComponentPlaceholder[0])))).exceptionally(ex -> {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.reload-failure", "<red>Failed to reload rules: {error}", LanguageManager.ComponentPlaceholder.of("{error}", ex.getMessage())));
            return null;
        });
    }

    private void showUsage(Player player) {
        player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.usage", "<yellow>Usage: <white>/rules [accept|reload]", new LanguageManager.ComponentPlaceholder[0]));
    }
}

