/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.lunark.io.commands.config.ScoreboardConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.scoreboard.ScoreboardStorage;
import net.lunark.io.scoreboard.ScoreboardUpdater;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ScoreboardCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION_BASE = "serveressentials.command.scoreboard";
    private static final String PERMISSION_RELOAD = "serveressentials.command.scoreboard.reload";
    private static final String PERMISSION_TOGGLE = "serveressentials.command.scoreboard.toggle";
    private static final String PERMISSION_COLOR = "serveressentials.command.scoreboard.color";
    private final PlayerLanguageManager langManager;
    private final ScoreboardConfig config;
    private final ScoreboardStorage storage;
    private final ScoreboardUpdater updater;
    private final Plugin plugin;

    public ScoreboardCommand(Plugin plugin, PlayerLanguageManager langManager, ScoreboardConfig config, ScoreboardStorage storage, ScoreboardUpdater updater) {
        this.langManager = langManager;
        this.config = config;
        this.storage = storage;
        this.updater = updater;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subcommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.scoreboard.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.disabled", "<red>Scoreboard system is disabled!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!player.hasPermission(PERMISSION_BASE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_BASE)));
            return true;
        }
        if (args.length == 0) {
            this.showUsage(player);
            return true;
        }
        switch (subcommand = args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(player);
                break;
            }
            case "toggle": {
                this.handleToggle(player);
                break;
            }
            case "color": {
                this.handleColor(player, args);
                break;
            }
            default: {
                this.showUsage(player);
            }
        }
        return true;
    }

    private void showUsage(Player player) {
        player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.usage", "<yellow>Usage:</yellow> /scoreboard <reload|toggle|color> [layout]", new LanguageManager.ComponentPlaceholder[0]));
    }

    private void handleReload(Player player) {
        if (!player.hasPermission(PERMISSION_RELOAD)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.no-permission-reload", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_RELOAD)));
            return;
        }
        this.updater.refreshAll();
        player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.reload.success", "<green>Scoreboards reloaded successfully!", new LanguageManager.ComponentPlaceholder[0]));
    }

    private void handleToggle(Player player) {
        if (!player.hasPermission(PERMISSION_TOGGLE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.no-permission-toggle", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_TOGGLE)));
            return;
        }
        UUID uuid = player.getUniqueId();
        boolean current = this.storage.isEnabled(uuid);
        boolean newState = !current;
        this.storage.setEnabled(uuid, newState).thenAccept(v -> Bukkit.getScheduler().runTask(this.plugin, () -> {
            if (newState) {
                this.updater.update(player);
                player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.toggle.enabled", "<green>Scoreboard enabled!", new LanguageManager.ComponentPlaceholder[0]));
            } else {
                this.updater.clear(player);
                player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.toggle.disabled", "<gray>Scoreboard disabled!", new LanguageManager.ComponentPlaceholder[0]));
            }
        }));
    }

    private void handleColor(Player player, String[] args) {
        if (!player.hasPermission(PERMISSION_COLOR)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.no-permission-color", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_COLOR)));
            return;
        }
        if (args.length < 2) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.color.usage", "<red>Usage: /scoreboard color <layout>", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        String layout = args[1].toLowerCase();
        if (!this.config.layoutExists(layout)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.color.not-found", "<red>Layout '<yellow>{layout}' not found!", LanguageManager.ComponentPlaceholder.of("{layout}", layout)));
            return;
        }
        UUID uuid = player.getUniqueId();
        this.storage.setLayout(uuid, layout).thenAccept(v -> Bukkit.getScheduler().runTask(this.plugin, () -> {
            this.updater.update(player, layout);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.scoreboard.color.changed", "<green>Layout changed to <yellow>{layout}</yellow>!", LanguageManager.ComponentPlaceholder.of("{layout}", layout)));
        }));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_BASE)) {
            return List.of();
        }
        if (!this.config.enabled) {
            return List.of();
        }
        if (args.length == 1) {
            return Arrays.asList("reload", "toggle", "color").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("color")) {
            return this.config.getLayoutNames().stream().filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return List.of();
    }
}

