/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.SeenConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SeenCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.seen";
    private final PlayerLanguageManager langManager;
    private final SeenConfig config;
    private final CommandDataStorage dataStorage;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SeenCommand(PlayerLanguageManager langManager, SeenConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String playerName;
        OfflinePlayer exact;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.seen.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.seen.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.seen.usage", "<yellow>Usage: <white>/seen <player>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayerIfCached((String)args[0]);
        if (target == null && (exact = Bukkit.getOfflinePlayer((String)args[0])) != null && (exact.hasPlayedBefore() || exact.isOnline())) {
            target = exact;
        }
        if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.seen.player-not-found", "<red>Player <yellow>{player}</yellow> not found.", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
            return true;
        }
        String string = playerName = target.getName() != null ? target.getName() : args[0];
        if (target.getFirstPlayed() == 0L) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.seen.never-joined", "<yellow>{player} <yellow>has never joined the server.", LanguageManager.ComponentPlaceholder.of("{player}", playerName)));
            return true;
        }
        String lastSeen = this.dateFormat.format(new Date(target.getLastPlayed()));
        if (target.isOnline()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.seen.result-online", "<green>{player} <green>is currently <bold>online</bold>!", LanguageManager.ComponentPlaceholder.of("{player}", playerName)));
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.seen.result", "<green>{player} <green>was last seen on <white>{lastSeen}", LanguageManager.ComponentPlaceholder.of("{player}", playerName), LanguageManager.ComponentPlaceholder.of("{lastSeen}", lastSeen)));
        }
        UUID playerId = player.getUniqueId();
        OfflinePlayer finalTarget = target;
        this.dataStorage.getState(playerId, "seen", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "seen", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "seen", "last_target", finalTarget.getUniqueId().toString());
        });
        return true;
    }
}

