/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import net.lunark.io.commands.config.SellConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.sellgui.SellGUIManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SellCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.sell";
    private static final String COMMAND_NAME = "sell";
    private final PlayerLanguageManager langManager;
    private final SellConfig config;
    private final SellGUIManager guiManager;

    public SellCommand(PlayerLanguageManager langManager, SellConfig config, SellGUIManager guiManager) {
        this.langManager = langManager;
        this.config = config;
        this.guiManager = guiManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.sell.only-player", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.sell.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.disabled", "<red>The sell GUI is currently disabled.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        this.guiManager.openSellGUI(player);
        return true;
    }
}

