/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.SleepConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SleepCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.sleep";
    private final PlayerLanguageManager langManager;
    private final SleepConfig config;
    private final CommandDataStorage dataStorage;

    public SleepCommand(PlayerLanguageManager langManager, SleepConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.sleep.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.sleep.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        World world = player.getWorld();
        world.setTime(this.config.timeToSet());
        if (this.config.clearWeather()) {
            world.setStorm(false);
            world.setThundering(false);
            world.setWeatherDuration(this.config.weatherDuration());
        }
        player.sendMessage(this.langManager.getMessageFor(player, "commands.sleep.success", "<green>The night has been skipped and the weather cleared!", new LanguageManager.ComponentPlaceholder[0]));
        if (this.config.broadcastMessage()) {
            Component broadcastMsg = this.langManager.getMessageFor(null, "commands.sleep.broadcast", "<yellow>{player} <green>skipped the night! <gray>(Sleep command)", LanguageManager.ComponentPlaceholder.of("{player}", player.getName()));
            Bukkit.broadcast((Component)broadcastMsg);
        }
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "sleep", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "sleep", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "sleep", "last_world", world.getName());
        });
        return true;
    }
}

