/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.lunark.io.commands.config.SpawnerConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public final class SpawnerCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.spawner";
    private final PlayerLanguageManager langManager;
    private final SpawnerConfig config;

    public SpawnerCommand(PlayerLanguageManager langManager, SpawnerConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        BlockState blockState;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.spawner.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.no-permission", "<red>You don't have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (player.getTargetBlockExact(5) == null || !((blockState = player.getTargetBlockExact(5).getState()) instanceof CreatureSpawner)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.look-at-spawner", "<red>Look at a spawner to change it!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        CreatureSpawner spawner = (CreatureSpawner)blockState;
        if (args.length == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.usage", "<yellow>Usage: /spawner <mob>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String mobName = args[0].toUpperCase(Locale.ROOT);
        try {
            EntityType type = EntityType.valueOf((String)mobName);
            String mobNameLower = mobName.toLowerCase(Locale.ROOT);
            String mobPermission = "serveressentials.spawner." + mobNameLower;
            if (!player.hasPermission("serveressentials.spawner.*") && !player.hasPermission(mobPermission)) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.no-permission-mob", "<red>You don't have permission to set a spawner to {mob}!", LanguageManager.ComponentPlaceholder.of("{mob}", mobNameLower)));
                return true;
            }
            spawner.setSpawnedType(type);
            spawner.update();
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.changed", "<green>Spawner type changed to {mob}", LanguageManager.ComponentPlaceholder.of("{mob}", mobNameLower)));
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.invalid-mob", "<red>Invalid mob type: {mob}", LanguageManager.ComponentPlaceholder.of("{mob}", args[0])));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player player;
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!(sender instanceof Player) || !(player = (Player)sender).hasPermission(PERMISSION)) {
            return suggestions;
        }
        if (args.length == 1) {
            for (EntityType type : EntityType.values()) {
                if (!type.isAlive()) continue;
                String mobName = type.name().toLowerCase(Locale.ROOT);
                String mobPermission = "serveressentials.spawner." + mobName;
                if (!player.hasPermission("serveressentials.spawner.*") && !player.hasPermission(mobPermission)) continue;
                suggestions.add(mobName);
            }
        }
        return suggestions;
    }
}

