/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.SuicideConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SuicideCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.suicide";
    private final PlayerLanguageManager langManager;
    private final SuicideConfig config;
    private final CommandDataStorage dataStorage;

    public SuicideCommand(PlayerLanguageManager langManager, SuicideConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.suicide.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.suicide.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        UUID playerId = player.getUniqueId();
        ((CompletableFuture)this.dataStorage.getState(playerId, "suicide", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "suicide", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "suicide", "last_used", String.valueOf(System.currentTimeMillis()));
        })).exceptionally(ex -> {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.suicide.error", "<red>Failed to record suicide attempt.", new LanguageManager.ComponentPlaceholder[0]));
            return null;
        });
        player.setHealth(0.0);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.suicide.success", "<dark_red>You have taken your own life.", new LanguageManager.ComponentPlaceholder[0]));
        return true;
    }
}

