/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.vault.VaultManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class VaultCommand
implements CommandExecutor {
    private final VaultManager vaultManager;
    private final PlayerLanguageManager langManager;

    public VaultCommand(VaultManager vaultManager, PlayerLanguageManager langManager) {
        this.vaultManager = vaultManager;
        this.langManager = langManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "vault.only-players", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            try {
                int vaultNumber = Integer.parseInt(args[0]);
                if (vaultNumber < 1 || vaultNumber > 10) {
                    player.sendMessage(this.langManager.getMessageFor(player, "vault.invalid-number", "<red>Vault number must be between 1-10!", new LanguageManager.ComponentPlaceholder[0]));
                    return true;
                }
                this.vaultManager.openVault(player, vaultNumber);
                return true;
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.langManager.getMessageFor(player, "vault.invalid-number", "<red>Invalid vault number!", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
        }
        this.openVaultSelector(player);
        return true;
    }

    private void openVaultSelector(Player player) {
        Component title = this.langManager.getMessageFor(player, "vault.selector.title", "<yellow>Select a Vault", new LanguageManager.ComponentPlaceholder[0]);
        Inventory gui = Bukkit.createInventory(null, (int)45, (Component)title);
        int[] slots = new int[]{10, 12, 14, 16, 28, 30, 32, 34};
        for (int i = 0; i < 8; ++i) {
            gui.setItem(slots[i], this.createVaultItem(player, i + 1));
        }
        gui.setItem(33, this.createVaultItem(player, 9));
        gui.setItem(31, this.createVaultItem(player, 10));
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = close.getItemMeta();
        closeMeta.displayName(this.langManager.getMessageFor(player, "vault.selector.close", "<red>Close", new LanguageManager.ComponentPlaceholder[0]));
        close.setItemMeta(closeMeta);
        gui.setItem(40, close);
        player.openInventory(gui);
    }

    private ItemStack createVaultItem(Player player, int number) {
        String perm = "serveressentials.command.pv." + number;
        boolean has = player.hasPermission(perm);
        Material mat = has ? Material.BARREL : Material.BARRIER;
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        Component name = has ? this.langManager.getMessageFor(player, "vault.selector.unlocked", "<green>Vault <white>#" + number, new LanguageManager.ComponentPlaceholder[0]) : this.langManager.getMessageFor(player, "vault.selector.locked", "<red>Vault <white>#" + number + " <red>\ud83d\udd12", new LanguageManager.ComponentPlaceholder[0]);
        meta.displayName(name);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(this.langManager.getMessageFor(player, has ? "vault.selector.click-to-open" : "vault.selector.no-permission", has ? "<gray>Click to open" : "<gray>No permission", new LanguageManager.ComponentPlaceholder[0]));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

