/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.WeatherConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class WeatherCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.weather";
    private static final String PERMISSION_CLEAR = "serveressentials.command.weather.clear";
    private static final String PERMISSION_RAIN = "serveressentials.command.weather.rain";
    private static final String PERMISSION_THUNDER = "serveressentials.command.weather.thunderstorm";
    private final PlayerLanguageManager langManager;
    private final WeatherConfig config;
    private final CommandDataStorage dataStorage;

    public WeatherCommand(PlayerLanguageManager langManager, WeatherConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String type;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.weather.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.usage", "<red>Usage: <white>/weather <clear|rain|thunderstorm>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        World world = player.getWorld();
        switch (type = args[0].toLowerCase()) {
            case "clear": {
                if (!player.hasPermission(PERMISSION_CLEAR)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_CLEAR)));
                    return true;
                }
                world.setStorm(false);
                world.setThundering(false);
                world.setWeatherDuration(this.config.durationTicks());
                player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.clear", "<green>Weather set to clear for <white>{duration} <green>seconds.", LanguageManager.ComponentPlaceholder.of("{duration}", this.config.durationTicks() / 20)));
                break;
            }
            case "rain": {
                if (!player.hasPermission(PERMISSION_RAIN)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_RAIN)));
                    return true;
                }
                world.setStorm(true);
                world.setThundering(false);
                world.setWeatherDuration(this.config.durationTicks());
                player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.rain", "<green>Weather set to rain for <white>{duration} <green>seconds.", LanguageManager.ComponentPlaceholder.of("{duration}", this.config.durationTicks() / 20)));
                break;
            }
            case "thunderstorm": {
                if (!player.hasPermission(PERMISSION_THUNDER)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_THUNDER)));
                    return true;
                }
                world.setStorm(true);
                world.setThundering(true);
                world.setWeatherDuration(this.config.durationTicks());
                player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.thunderstorm", "<green>Weather set to thunderstorm for <white>{duration} <green>seconds.", LanguageManager.ComponentPlaceholder.of("{duration}", this.config.durationTicks() / 20)));
                break;
            }
            default: {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.invalid-type", "<red>Invalid weather type. Use: clear, rain, or thunderstorm.", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
        }
        UUID playerId = player.getUniqueId();
        this.dataStorage.setState(playerId, "weather", "last_type", type);
        this.dataStorage.getState(playerId, "weather", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "weather", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "weather", "last_used", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            String partial = args[0].toLowerCase();
            if (player.hasPermission(PERMISSION_CLEAR) && "clear".startsWith(partial)) {
                options.add("clear");
            }
            if (player.hasPermission(PERMISSION_RAIN) && "rain".startsWith(partial)) {
                options.add("rain");
            }
            if (player.hasPermission(PERMISSION_THUNDER) && "thunderstorm".startsWith(partial)) {
                options.add("thunderstorm");
            }
            return options;
        }
        return List.of();
    }
}

