/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class GlobalConfigManager {
    private final Plugin plugin;
    private FileConfiguration cfg;
    private final File configFile;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public GlobalConfigManager(Plugin plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        this.load();
    }

    public void load() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.cfg = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void reload() {
        this.load();
    }

    public FileConfiguration getConfig() {
        return this.cfg;
    }

    public String getString(String path, String def) {
        return this.cfg.getString(path, def);
    }

    public int getInt(String path, int def) {
        return this.cfg.getInt(path, def);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.cfg.getBoolean(path, def);
    }

    public void set(String path, Object value) {
        this.cfg.set(path, value);
        try {
            this.cfg.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save config.yml", e);
        }
    }
}

