/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.commands.config.ShopConfig;
import net.lunark.io.economy.MainShopConfig;
import net.lunark.io.economy.ServerEssentialsEconomy;
import net.lunark.io.economy.ShopConfigLoader;
import net.lunark.io.economy.ShopSectionConfig;
import net.lunark.io.economy.ShopStorage;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class ShopGUIManager {
    private static final MiniMessage mini = MiniMessage.miniMessage();
    private static final long CLICK_COOLDOWN_MS = 200L;
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final ShopStorage storage;
    private final ShopConfig config;
    private final ServerEssentialsEconomy economy;
    private final Map<UUID, String> openSection = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Integer> currentPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> clickCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Set<UUID> mainGUIOpen = ConcurrentHashMap.newKeySet();

    public ShopGUIManager(Plugin plugin, PlayerLanguageManager langManager, ShopStorage storage, ShopConfig config, ServerEssentialsEconomy economy) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.economy = economy;
    }

    public void openMainGUI(Player player) {
        File mainFile = new File(this.config.getShopFolder(), "main.yml");
        if (!mainFile.exists()) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.shop.no-main-config", "<red>Shop configuration not found. Please contact an administrator.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        MainShopConfig main = ShopConfigLoader.loadMainConfig(mainFile);
        Component title = this.langManager.getMessageFor(player, "economy.shop.main-title", "<green>Main Shop", new LanguageManager.ComponentPlaceholder[0]);
        Inventory inv = Bukkit.createInventory(null, (int)this.config.mainSize, (Component)title);
        main.layout.forEach((slot, item) -> {
            ItemStack stack = this.createItem(item.material, item.name, null, 1);
            inv.setItem(slot.intValue(), stack);
        });
        main.sectionButtons.forEach((slot, button) -> {
            ItemStack stack = this.createItem(button.material, button.name, button.lore, 1);
            inv.setItem(slot.intValue(), stack);
        });
        ItemStack close = this.createItem(Material.BARRIER, "<red>Close", null, 1);
        inv.setItem(this.config.closeButtonSlot, close);
        player.openInventory(inv);
        this.openSection.remove(player.getUniqueId());
        this.mainGUIOpen.add(player.getUniqueId());
    }

    public void openSectionGUI(Player player, String fileName, int page) {
        int closeSlot;
        int headSlot;
        File sectionFile = new File(this.config.getShopFolder(), fileName);
        if (!sectionFile.exists()) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.shop.no-section", "<red>Shop section not found: <white>{section}", LanguageManager.ComponentPlaceholder.of("{section}", fileName)));
            return;
        }
        ShopSectionConfig section = ShopConfigLoader.loadSectionConfig(sectionFile);
        String displayTitle = section.title != null ? section.title : fileName.replace(".yml", "").replace("-", " ");
        Component title = this.langManager.getMessageFor(player, "economy.shop.section-title", "<green>{section} Shop", LanguageManager.ComponentPlaceholder.of("{section}", displayTitle));
        Inventory inv = Bukkit.createInventory(null, (int)section.size, (Component)title);
        section.layout.forEach((slot, item) -> {
            ItemStack stack = this.createItem(item.material, item.name, item.lore, 1);
            inv.setItem(slot.intValue(), stack);
        });
        section.items.values().stream().filter(item -> item.page == page).forEach(item -> {
            ItemStack stack = this.createItem(item.material, item.name, item.lore, item.amount);
            inv.setItem(item.slot, stack);
        });
        int n = headSlot = section.playerHeadSlot >= 0 ? section.playerHeadSlot : this.config.playerHeadSlot;
        if (headSlot >= 0) {
            ItemStack skull = this.createPlayerHead(player);
            inv.setItem(headSlot, skull);
        }
        int n2 = closeSlot = section.closeButtonSlot >= 0 ? section.closeButtonSlot : this.config.closeButtonSlot;
        if (closeSlot >= 0) {
            ItemStack back = this.createItem(Material.BARRIER, "<red>Back", null, 1);
            inv.setItem(closeSlot, back);
        }
        if (page > 1) {
            ItemStack prev = this.createItem(Material.ARROW, "<gray>Previous Page", null, 1);
            inv.setItem(45, prev);
        }
        if (page < section.pages) {
            ItemStack next = this.createItem(Material.ARROW, "<gray>Next Page", null, 1);
            inv.setItem(53, next);
        }
        player.openInventory(inv);
        this.openSection.put(player.getUniqueId(), fileName);
        this.currentPage.put(player.getUniqueId(), page);
        this.mainGUIOpen.remove(player.getUniqueId());
        this.storage.setPlayerSection(player.getUniqueId(), fileName);
        this.storage.setPlayerPage(player.getUniqueId(), page);
    }

    public void handleClick(Player player, int slot, String clickType, Inventory inv) {
        boolean isMain;
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.clickCooldowns.getOrDefault(uuid, 0L) > currentTime) {
            return;
        }
        this.clickCooldowns.put(uuid, currentTime + 200L);
        String sectionFile = this.openSection.get(uuid);
        boolean bl = isMain = sectionFile == null;
        if (isMain) {
            this.handleMainMenuClick(player, slot);
        } else {
            int page = this.currentPage.getOrDefault(uuid, 1);
            this.handleSectionClick(player, slot, page, sectionFile, clickType);
        }
    }

    private void handleMainMenuClick(Player player, int slot) {
        File mainFile = new File(this.config.getShopFolder(), "main.yml");
        if (!mainFile.exists()) {
            return;
        }
        MainShopConfig main = ShopConfigLoader.loadMainConfig(mainFile);
        if (slot == this.config.closeButtonSlot) {
            player.closeInventory();
            return;
        }
        MainShopConfig.SectionButton button = main.sectionButtons.get(slot);
        if (button != null) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, button.file, 1));
        }
    }

    private void handleSectionClick(Player player, int slot, int page, String sectionFile, String clickType) {
        int closeSlot;
        File sectionFileObject = new File(this.config.getShopFolder(), sectionFile);
        if (!sectionFileObject.exists()) {
            return;
        }
        ShopSectionConfig section = ShopConfigLoader.loadSectionConfig(sectionFileObject);
        if (slot == 45 && page > 1) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, sectionFile, page - 1));
            return;
        }
        if (slot == 53 && page < section.pages) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, sectionFile, page + 1));
            return;
        }
        int n = closeSlot = section.closeButtonSlot >= 0 ? section.closeButtonSlot : this.config.closeButtonSlot;
        if (slot == closeSlot) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
            return;
        }
        for (ShopSectionConfig.ShopItem item : section.items.values()) {
            if (item.page != page || item.slot != slot || !item.clickable) continue;
            boolean isLeftClick = clickType.equals("LEFT");
            boolean isRightClick = clickType.equals("RIGHT");
            if (isLeftClick && item.buyPrice > 0.0) {
                this.handleBuy(player, item);
                break;
            }
            if (!isRightClick || !(item.sellPrice > 0.0) || !this.config.enableSell) break;
            this.handleSell(player, item);
            break;
        }
    }

    private void handleBuy(Player player, ShopSectionConfig.ShopItem item) {
        double balance = this.economy.getBalance((OfflinePlayer)player);
        if (balance >= item.buyPrice) {
            this.economy.withdrawPlayer((OfflinePlayer)player, item.buyPrice);
            player.getInventory().addItem(new ItemStack[]{new ItemStack(item.material, item.amount)});
            player.sendMessage(this.langManager.getMessageFor(player, "economy.shop.buy-success", "<green>You bought {amount}x {item} for {symbol}{price}", LanguageManager.ComponentPlaceholder.of("{amount}", item.amount), LanguageManager.ComponentPlaceholder.of("{item}", item.name), LanguageManager.ComponentPlaceholder.of("{price}", String.format("%.2f", item.buyPrice)), LanguageManager.ComponentPlaceholder.of("{symbol}", this.config.currencySymbol)));
            this.refreshGUI(player);
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.shop.cannot-afford", "<red>You cannot afford {item} (cost: {symbol}{price})", LanguageManager.ComponentPlaceholder.of("{item}", item.name), LanguageManager.ComponentPlaceholder.of("{price}", String.format("%.2f", item.buyPrice)), LanguageManager.ComponentPlaceholder.of("{symbol}", this.config.currencySymbol)));
        }
    }

    private void handleSell(Player player, ShopSectionConfig.ShopItem item) {
        if (!player.getInventory().containsAtLeast(new ItemStack(item.material), item.amount)) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.shop.no-items", "<red>You don't have enough {item} to sell", LanguageManager.ComponentPlaceholder.of("{item}", item.name)));
            return;
        }
        this.removeItems(player, item.material, item.amount);
        this.economy.depositPlayer((OfflinePlayer)player, item.sellPrice);
        player.sendMessage(this.langManager.getMessageFor(player, "economy.shop.sell-success", "<green>You sold {amount}x {item} for {symbol}{price}", LanguageManager.ComponentPlaceholder.of("{amount}", item.amount), LanguageManager.ComponentPlaceholder.of("{item}", item.name), LanguageManager.ComponentPlaceholder.of("{price}", String.format("%.2f", item.sellPrice)), LanguageManager.ComponentPlaceholder.of("{symbol}", this.config.currencySymbol)));
        this.refreshGUI(player);
    }

    private void refreshGUI(Player player) {
        String section = this.openSection.get(player.getUniqueId());
        int page = this.currentPage.getOrDefault(player.getUniqueId(), 1);
        if (section != null) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, section, page));
        }
    }

    public void refreshOpenInventories() {
        new HashSet<UUID>(this.openSection.keySet()).forEach(uuid -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null && player.getOpenInventory().getTopInventory().getHolder() == null) {
                String section = this.openSection.get(uuid);
                int page = this.currentPage.getOrDefault(uuid, 1);
                if (section == null) {
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
                } else {
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, section, page));
                }
            }
        });
    }

    public boolean isShopGUIOpen(UUID playerUuid) {
        return this.mainGUIOpen.contains(playerUuid) || this.openSection.containsKey(playerUuid);
    }

    public void cleanupPlayer(UUID playerUuid) {
        this.openSection.remove(playerUuid);
        this.currentPage.remove(playerUuid);
        this.mainGUIOpen.remove(playerUuid);
        this.clickCooldowns.remove(playerUuid);
    }

    private void removeItems(Player player, Material material, int amount) {
        int remaining = amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getType() != material) continue;
            int stackAmount = stack.getAmount();
            if (stackAmount <= remaining) {
                player.getInventory().clear(i);
                remaining -= stackAmount;
            } else {
                stack.setAmount(stackAmount - remaining);
                remaining = 0;
            }
            if (remaining <= 0) break;
        }
        player.updateInventory();
    }

    private ItemStack createItem(Material material, String name, List<String> lore, int amount) {
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (name != null) {
                meta.displayName(mini.deserialize(name));
            }
            if (lore != null) {
                List<Component> loreComponents = lore.stream().map(line -> mini.deserialize(line)).toList();
                meta.lore(loreComponents);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createPlayerHead(Player player) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer((OfflinePlayer)player);
            meta.displayName(this.langManager.getMessageFor(player, "economy.shop.balance-display", "<green>Your Balance: <gold>{balance}", LanguageManager.ComponentPlaceholder.of("{balance}", String.format("%.2f", this.economy.getBalance((OfflinePlayer)player)))));
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }
}

