/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.homes;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lunark.io.homes.Home;
import net.lunark.io.homes.HomeStorage;

public class HomeManager {
    private final HomeStorage storage;
    private final int maxHomes;

    public HomeManager(HomeStorage storage, int maxHomes) {
        this.storage = storage;
        this.maxHomes = maxHomes;
    }

    public CompletableFuture<Optional<Home>> getHome(UUID playerId, int slot) {
        return this.storage.getHome(playerId, slot);
    }

    public CompletableFuture<Boolean> setHome(UUID playerId, int slot, Home home) {
        if (slot < 1 || slot > this.maxHomes) {
            return CompletableFuture.completedFuture(false);
        }
        return this.storage.setHome(playerId, slot, home).thenApply(v -> true);
    }

    public CompletableFuture<Boolean> removeHome(UUID playerId, int slot) {
        return this.storage.removeHome(playerId, slot).thenApply(v -> true);
    }

    public CompletableFuture<Map<Integer, Home>> getAllHomes(UUID playerId) {
        return this.storage.getAllHomes(playerId);
    }

    public CompletableFuture<Integer> countHomes(UUID playerId) {
        return this.storage.getAllHomes(playerId).thenApply(Map::size);
    }
}

