/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.kit;

import net.lunark.io.kit.KitConfig;
import net.lunark.io.kit.KitConfigManager;
import net.lunark.io.kit.KitGUIListener;
import net.lunark.io.kit.KitManager;
import net.lunark.io.kit.storage.KitStorage;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class KitCommand
implements CommandExecutor {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final KitStorage kitStorage;
    private final KitConfig kitConfig;
    private final KitGUIListener guiListener;

    public KitCommand(Plugin plugin, PlayerLanguageManager langManager, KitStorage kitStorage, KitConfig kitConfig, KitGUIListener guiListener) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.kitStorage = kitStorage;
        this.kitConfig = kitConfig;
        this.guiListener = guiListener;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            Player p;
            if (!sender.hasPermission("serveressentials.command.kits.reload")) {
                Player p2;
                sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (p2 = (Player)sender) : null, "kits.no-permission", "<red>You don't have permission to reload kits!", LanguageManager.ComponentPlaceholder.of("{permission}", "kits.command.reload")).toString());
                return true;
            }
            this.reloadKits();
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (p = (Player)sender) : null, "kits.reload-success", "<green>\u2713 Kits reloaded successfully!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.command.kits")) {
            player.sendMessage(this.langManager.getMessageFor(player, "kits.no-permission", "<red>You don't have permission to use kits!", LanguageManager.ComponentPlaceholder.of("{permission}", "kits.command.use")));
            return true;
        }
        this.guiListener.openKitGUI(player);
        return true;
    }

    private void reloadKits() {
        KitConfigManager.reload();
        this.kitConfig.load();
        this.plugin.getLogger().info("Kits reloaded: " + KitManager.getKits().size() + " kits loaded.");
    }
}

