/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.language;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.plugin.Plugin;

public class LanguageManager {
    private final Plugin plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Gson gson = new Gson();
    private final Map<String, Map<String, JsonElement>> languageData = new HashMap<String, Map<String, JsonElement>>();
    private String defaultLanguage = "en";

    public LanguageManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public LanguageManager() {
        this.plugin = null;
    }

    public void loadLanguages() {
        File[] files;
        File defaultFile;
        this.languageData.clear();
        File langDir = new File(this.plugin.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        if (!(defaultFile = new File(langDir, "en.json")).exists()) {
            this.plugin.saveResource("lang/en.json", false);
        }
        if ((files = langDir.listFiles((dir, name) -> name.endsWith(".json"))) == null) {
            return;
        }
        for (File file : files) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                Type type = new TypeToken<Map<String, JsonElement>>(this){}.getType();
                Map data = (Map)this.gson.fromJson((Reader)reader, type);
                String langId = file.getName().replace(".json", "").toLowerCase(Locale.ROOT);
                this.languageData.put(langId, data != null ? data : new HashMap());
                this.plugin.getLogger().info("Loaded language: " + langId + " (" + data.size() + " keys)");
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load language: " + file.getName(), ex);
            }
        }
    }

    public Set<String> getAvailableLanguages() {
        return Collections.unmodifiableSet(this.languageData.keySet());
    }

    public boolean hasLanguage(String langId) {
        return this.languageData.containsKey(langId.toLowerCase(Locale.ROOT));
    }

    public void setDefaultLanguage(String langId) {
        if (this.hasLanguage(langId)) {
            this.defaultLanguage = langId.toLowerCase(Locale.ROOT);
        }
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    private Map<String, JsonElement> getLangMap(String langId) {
        langId = langId != null ? langId.toLowerCase(Locale.ROOT) : this.defaultLanguage;
        return this.languageData.getOrDefault(langId, this.languageData.getOrDefault(this.defaultLanguage, Map.of()));
    }

    private Optional<JsonElement> getRawElement(String langId, String key) {
        Map<String, JsonElement> langMap = this.getLangMap(langId);
        String[] parts = key.split("\\.");
        JsonElement element = null;
        for (String part : parts) {
            if (element == null) {
                element = langMap.get(part);
            } else if (element.isJsonObject()) {
                element = element.getAsJsonObject().get(part);
            } else {
                return Optional.empty();
            }
            if (element != null) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(element);
    }

    public String getString(String langId, String key, String def, ComponentPlaceholder ... placeholders) {
        String raw;
        JsonElement element = this.getRawElement(langId, key).orElse(null);
        if (element == null) {
            raw = def;
        } else if (element.isJsonPrimitive()) {
            raw = element.getAsString();
        } else if (element.isJsonArray()) {
            ArrayList lines = new ArrayList();
            element.getAsJsonArray().forEach(el -> lines.add(el.getAsString()));
            raw = String.join((CharSequence)"\n", lines);
        } else {
            raw = this.gson.toJson(element);
        }
        return this.replacePlaceholders(raw, placeholders);
    }

    public String getString(String key, String def, ComponentPlaceholder ... placeholders) {
        return this.getString(null, key, def, placeholders);
    }

    public Component getComponent(String langId, String key, String def, ComponentPlaceholder ... placeholders) {
        String raw = this.getString(langId, key, def, placeholders);
        try {
            return this.miniMessage.deserialize(raw);
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.WARNING, "Invalid MiniMessage at '" + key + "': " + raw, ex);
            return Component.text(raw);
        }
    }

    public Component getComponent(String key, String def, ComponentPlaceholder ... placeholders) {
        return this.getComponent(null, key, def, placeholders);
    }

    public List<Component> getComponentList(String langId, String key) {
        JsonElement element = this.getRawElement(langId, key).orElse(null);
        ArrayList<Component> components = new ArrayList<Component>();
        if (element == null) {
            return components;
        }
        if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(el -> {
                if (el.isJsonPrimitive()) {
                    components.add((Component)this.miniMessage.deserialize(el.getAsString()));
                }
            });
        } else if (element.isJsonPrimitive()) {
            components.add((Component)this.miniMessage.deserialize(element.getAsString()));
        }
        return components;
    }

    public void reloadLanguages() {
        this.plugin.getLogger().info("Reloading language files...");
        this.loadLanguages();
        this.plugin.getLogger().info("Reloaded " + this.languageData.size() + " languages!");
    }

    private String replacePlaceholders(String raw, ComponentPlaceholder ... placeholders) {
        if (placeholders == null) {
            return raw;
        }
        for (ComponentPlaceholder ph : placeholders) {
            raw = raw.replace(ph.placeholder(), ph.value());
        }
        return raw;
    }

    public record ComponentPlaceholder(String placeholder, String value) {
        public static ComponentPlaceholder of(String placeholder, Object value) {
            return new ComponentPlaceholder(placeholder, String.valueOf(value));
        }
    }
}

