/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.lobby;

import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.config.LobbyConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.lobby.AnimationHelper;
import net.lunark.io.lobby.LobbyStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class LobbyListener
implements Listener {
    private final PlayerLanguageManager langManager;
    private final LobbyStorage storage;
    private final LobbyConfig config;

    public LobbyListener(PlayerLanguageManager langManager, LobbyStorage storage, LobbyConfig config) {
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.teleportOnJoin) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("serveressentials.command.lobby")) {
            return;
        }
        String worldKey = this.config.perWorld ? player.getWorld().getName() : "global";
        ((CompletableFuture)this.storage.getLobby(worldKey).thenAccept(optLocation -> {
            if (optLocation.isPresent()) {
                Location lobby = (Location)optLocation.get();
                Bukkit.getScheduler().runTask(this.config.plugin, () -> {
                    if (this.config.animationEnabled) {
                        AnimationHelper.playTeleportAnimation(this.config.plugin, player, this.config.animation);
                    }
                    player.teleport(lobby);
                    player.sendMessage(this.langManager.getMessageFor(player, "lobby.teleported", "<green>Teleported to lobby!", new LanguageManager.ComponentPlaceholder[0]));
                });
            }
        })).exceptionally(ex -> {
            this.config.plugin.getLogger().severe("Failed to teleport player on join: " + ex.getMessage());
            return null;
        });
    }
}

