/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.rules;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.lunark.io.commands.config.RulesConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.rules.RulesListener;
import net.lunark.io.rules.RulesStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RulesGUI {
    private final PlayerLanguageManager langManager;
    private final RulesStorage storage;
    private final RulesConfig config;
    private final Plugin plugin;
    private static final int GUI_SIZE = 54;
    private final Material fillerMaterial;

    public RulesGUI(PlayerLanguageManager langManager, RulesStorage storage, RulesConfig config, Plugin plugin) {
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.plugin = plugin;
        this.fillerMaterial = Material.matchMaterial((String)config.guiFillerMaterial());
    }

    public void showRules(Player player) {
        if (this.isViewingRules(player)) {
            return;
        }
        this.storage.getAllRules().thenAccept(rules -> {
            if (rules.isEmpty()) {
                player.sendMessage(this.langManager.getMessageFor(player, "rules.gui.no-rules", "<red>No rules are currently configured.", new LanguageManager.ComponentPlaceholder[0]));
                return;
            }
            Component titleComponent = this.langManager.getMessageFor(player, "rules.gui.title", this.config.title(), new LanguageManager.ComponentPlaceholder[0]);
            String legacyTitle = LegacyComponentSerializer.legacySection().serialize(titleComponent);
            Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)legacyTitle);
            if (this.fillerMaterial != null) {
                ItemStack filler = this.createFiller();
                for (int i = 0; i < 54; ++i) {
                    inv.setItem(i, filler);
                }
            }
            for (RulesStorage.Rule rule : rules) {
                int slot = rule.slot();
                if (slot < 0 || slot >= 54) continue;
                ItemStack ruleItem = this.createRuleItem(player, rule);
                inv.setItem(slot, ruleItem);
            }
            inv.setItem(this.config.acceptButtonSlot(), this.createAcceptButton(player));
            inv.setItem(this.config.declineButtonSlot(), this.createDeclineButton(player));
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                if (player.isOnline()) {
                    player.openInventory(inv);
                }
            });
        });
    }

    private boolean isViewingRules(Player player) {
        String currentTitle = player.getOpenInventory().getTitle();
        Component expectedTitle = this.langManager.getMessageFor(player, "rules.gui.title", this.config.title(), new LanguageManager.ComponentPlaceholder[0]);
        String expectedLegacy = LegacyComponentSerializer.legacySection().serialize(expectedTitle);
        return currentTitle.equals(expectedLegacy);
    }

    private ItemStack createFiller() {
        ItemStack filler = new ItemStack(this.fillerMaterial != null ? this.fillerMaterial : Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        meta.setDisplayName(" ");
        filler.setItemMeta(meta);
        return filler;
    }

    private ItemStack createRuleItem(Player player, RulesStorage.Rule rule) {
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        Component nameComponent = this.langManager.getMessageFor(player, "rules.gui.rule-name", "<white><bold>Rule #{number}", LanguageManager.ComponentPlaceholder.of("{number}", rule.orderIndex() + 1));
        meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(nameComponent));
        Component ruleComponent = this.langManager.getMessageFor(player, "rules.gui.rule-line", rule.text(), new LanguageManager.ComponentPlaceholder[0]);
        String parsedText = LegacyComponentSerializer.legacySection().serialize(ruleComponent);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        String[] words = parsedText.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() > 35) {
                lore.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lore.add(currentLine.toString());
        }
        lore.add("");
        Component hintComponent = this.langManager.getMessageFor(player, "rules.gui.rule-hint", "<gray><italic>Click accept below to continue", new LanguageManager.ComponentPlaceholder[0]);
        lore.add(LegacyComponentSerializer.legacySection().serialize(hintComponent));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createAcceptButton(Player player) {
        ItemStack item = new ItemStack(Material.GREEN_WOOL);
        ItemMeta meta = item.getItemMeta();
        Component nameComponent = this.langManager.getMessageFor(player, "rules.gui.accept-title", this.config.acceptButtonText(), new LanguageManager.ComponentPlaceholder[0]);
        meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(nameComponent));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createDeclineButton(Player player) {
        ItemStack item = new ItemStack(Material.RED_WOOL);
        ItemMeta meta = item.getItemMeta();
        Component nameComponent = this.langManager.getMessageFor(player, "rules.gui.decline-title", this.config.declineButtonText(), new LanguageManager.ComponentPlaceholder[0]);
        meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(nameComponent));
        item.setItemMeta(meta);
        return item;
    }

    public void handleAccept(Player player) {
        RulesListener.removePending(player.getUniqueId());
        player.closeInventory();
        ((CompletableFuture)((CompletableFuture)this.storage.getLatestVersion().thenCompose(version -> this.storage.acceptRules(player.getUniqueId(), (int)version))).thenAccept(v -> player.sendMessage(this.langManager.getMessageFor(player, "rules.accept.success", "<green><bold>\u2713 You accepted the server rules!", new LanguageManager.ComponentPlaceholder[0])))).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to accept rules for " + player.getName() + ": " + ex.getMessage());
            return null;
        });
    }

    public void handleDecline(Player player) {
        RulesListener.removePending(player.getUniqueId());
        player.closeInventory();
        player.kick(this.langManager.getMessageFor(player, "rules.decline.kick-message", this.config.kickMessage(), new LanguageManager.ComponentPlaceholder[0]));
    }
}

