/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.rules;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.lunark.io.commands.config.RulesConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.rules.RulesGUI;
import net.lunark.io.rules.RulesStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RulesListener
implements Listener {
    private final PlayerLanguageManager langManager;
    private final RulesStorage storage;
    private final RulesConfig config;
    private final RulesGUI gui;
    private final Plugin plugin;
    private static final ConcurrentHashMap<UUID, Boolean> pendingAcceptance = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Long> lastReopenTime = new ConcurrentHashMap();

    public RulesListener(PlayerLanguageManager langManager, RulesStorage storage, RulesConfig config, Plugin plugin) {
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.plugin = plugin;
        this.gui = new RulesGUI(langManager, storage, config, plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.mustAccept()) {
            return;
        }
        Player player = event.getPlayer();
        this.storage.hasAcceptedRules(player.getUniqueId()).thenAccept(accepted -> {
            if (!accepted.booleanValue()) {
                pendingAcceptance.put(player.getUniqueId(), true);
                Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                    if (player.isOnline()) {
                        this.gui.showRules(player);
                    }
                }, 40L);
            }
        });
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        Component expectedTitle = this.langManager.getMessageFor(player, "rules.gui.title", this.config.title(), new LanguageManager.ComponentPlaceholder[0]);
        String expectedLegacy = LegacyComponentSerializer.legacySection().serialize(expectedTitle);
        if (!title.equals(expectedLegacy)) {
            return;
        }
        Long lastOpen = lastReopenTime.get(player.getUniqueId());
        if (lastOpen != null && System.currentTimeMillis() - lastOpen < 1000L) {
            return;
        }
        if (this.config.forceAcceptance() && pendingAcceptance.containsKey(player.getUniqueId())) {
            this.storage.hasAcceptedRules(player.getUniqueId()).thenAccept(accepted -> {
                if (!accepted.booleanValue() && player.isOnline()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "rules.close.cannot-close", "<red>You must accept the rules before playing!", new LanguageManager.ComponentPlaceholder[0]));
                    lastReopenTime.put(player.getUniqueId(), System.currentTimeMillis());
                    Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                        if (player.isOnline() && pendingAcceptance.containsKey(player.getUniqueId())) {
                            this.gui.showRules(player);
                        }
                    }, 10L);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        pendingAcceptance.remove(event.getPlayer().getUniqueId());
        lastReopenTime.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        Component expectedTitle = this.langManager.getMessageFor(player, "rules.gui.title", this.config.title(), new LanguageManager.ComponentPlaceholder[0]);
        String expectedLegacy = LegacyComponentSerializer.legacySection().serialize(expectedTitle);
        if (!title.equals(expectedLegacy)) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        switch (item.getType()) {
            case GREEN_WOOL: {
                this.gui.handleAccept(player);
                break;
            }
            case RED_WOOL: {
                this.gui.handleDecline(player);
                break;
            }
        }
    }

    public static void removePending(UUID playerId) {
        pendingAcceptance.remove(playerId);
    }
}

