/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.scoreboard;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.commands.config.ScoreboardConfig;
import net.lunark.io.scoreboard.ScoreboardStorage;
import net.lunark.io.scoreboard.util.PlaceholderUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class ScoreboardUpdater {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final int MAX_LINES = 15;
    private static final long PLACEHOLDER_CACHE_TTL = TimeUnit.SECONDS.toMillis(1L);
    private final Plugin plugin;
    private final ScoreboardConfig config;
    private final ScoreboardStorage storage;
    private final Map<UUID, Scoreboard> playerBoards = new ConcurrentHashMap<UUID, Scoreboard>();
    private final Map<UUID, Objective> playerObjectives = new ConcurrentHashMap<UUID, Objective>();
    private final Map<UUID, Map<Integer, Team>> playerTeams = new ConcurrentHashMap<UUID, Map<Integer, Team>>();
    private final Map<UUID, Map<String, String>> placeholderCache = new ConcurrentHashMap<UUID, Map<String, String>>();
    private final Map<UUID, Long> lastPlaceholderUpdate = new ConcurrentHashMap<UUID, Long>();
    private final boolean debugMode;
    private static final String INVISIBLE_CHAR = "\u00a7";

    public ScoreboardUpdater(Plugin plugin, ScoreboardConfig config, ScoreboardStorage storage) {
        this.plugin = plugin;
        this.config = config;
        this.storage = storage;
        this.debugMode = plugin.getConfig().getBoolean("scoreboard.debug-mode", false);
        this.startTask();
        plugin.getLogger().info("Scoreboard updater started in " + (this.debugMode ? "debug" : "production") + " mode");
    }

    private void startTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, () -> {
            if (!this.config.enabled) {
                return;
            }
            Bukkit.getOnlinePlayers().forEach(this::updateAsync);
        }, 20L, (long)this.config.updateInterval);
    }

    private void updateAsync(Player player) {
        if (!this.config.enabled) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.clear(player));
            return;
        }
        if (!this.storage.isEnabled(player.getUniqueId())) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.clear(player));
            return;
        }
        String layout = this.config.getLayoutForPlayer(player, this.storage);
        Bukkit.getScheduler().runTask(this.plugin, () -> this.update(player, layout));
    }

    public void refreshAll() {
        if (!this.config.enabled) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(this::updateAsync);
    }

    public void clear(Player player) {
        UUID uuid = player.getUniqueId();
        player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        this.playerBoards.remove(uuid);
        this.playerObjectives.remove(uuid);
        this.playerTeams.remove(uuid);
        this.placeholderCache.remove(uuid);
        this.lastPlaceholderUpdate.remove(uuid);
    }

    public void update(Player player) {
        if (!this.config.enabled) {
            this.clear(player);
            return;
        }
        if (!this.storage.isEnabled(player.getUniqueId())) {
            this.clear(player);
            return;
        }
        String layout = this.config.getLayoutForPlayer(player, this.storage);
        this.update(player, layout);
    }

    public void update(Player player, String layout) {
        int i;
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.update(player, layout));
            return;
        }
        if (!this.config.enabled) {
            this.clear(player);
            return;
        }
        if (!this.storage.isEnabled(player.getUniqueId())) {
            this.clear(player);
            return;
        }
        String world = player.getWorld().getName();
        if (!this.config.isWorldEnabled(world)) {
            this.clear(player);
            return;
        }
        UUID uuid = player.getUniqueId();
        ScoreboardConfig.Layout layoutData = this.config.getLayout(layout);
        Scoreboard board = this.playerBoards.computeIfAbsent(uuid, k -> Bukkit.getScoreboardManager().getNewScoreboard());
        Objective obj = this.playerObjectives.computeIfAbsent(uuid, k -> {
            Objective o = board.registerNewObjective("se_sb", "dummy", MINI_MESSAGE.deserialize(layoutData.title()));
            o.setDisplaySlot(DisplaySlot.SIDEBAR);
            return o;
        });
        obj.displayName(MINI_MESSAGE.deserialize(layoutData.title()));
        Map teams = this.playerTeams.computeIfAbsent(uuid, k -> new ConcurrentHashMap());
        Map cache = this.placeholderCache.computeIfAbsent(uuid, k -> new ConcurrentHashMap());
        long lastUpdate = this.lastPlaceholderUpdate.getOrDefault(uuid, 0L);
        long now = System.currentTimeMillis();
        if (now - lastUpdate > PLACEHOLDER_CACHE_TTL) {
            cache.clear();
            this.lastPlaceholderUpdate.put(uuid, now);
        }
        List<String> lines = layoutData.lines();
        int visibleLines = Math.min(lines.size(), layoutData.maxLines());
        for (i = 0; i < visibleLines; ++i) {
            String line = lines.get(i);
            String cachedLine = (String)cache.get(line);
            if (cachedLine == null) {
                cachedLine = PlaceholderUtil.apply(player, line);
                cache.put(line, cachedLine);
            }
            String entry = INVISIBLE_CHAR + (char)(97 + i);
            int finalI = i;
            Team team = teams.computeIfAbsent(i, k -> {
                Team t = board.registerNewTeam("se_line_" + String.valueOf(uuid) + "_" + finalI);
                t.addEntry(entry);
                return t;
            });
            team.prefix(MINI_MESSAGE.deserialize(cachedLine));
            obj.getScore(entry).setScore(visibleLines - i);
        }
        for (i = visibleLines; i < 15; ++i) {
            Team team = (Team)teams.remove(i);
            if (team == null) continue;
            team.unregister();
        }
        if (player.getScoreboard() != board) {
            player.setScoreboard(board);
        }
    }
}

