/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.sellgui;

import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.sellgui.SellGUIManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SellGUIListener
implements Listener {
    private final SellGUIManager guiManager;
    private final PlayerLanguageManager langManager;
    private final MiniMessage mini = MiniMessage.miniMessage();

    public SellGUIListener(PlayerLanguageManager langManager, SellGUIManager guiManager) {
        this.langManager = langManager;
        this.guiManager = guiManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack cursor;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory topInv = event.getView().getTopInventory();
        if (topInv == null || !event.getView().title().toString().contains("Sell Items")) {
            return;
        }
        if (event.getView().getBottomInventory() == event.getClickedInventory() && event.getCursor() != null && event.getCursor().getType() != Material.AIR && !this.guiManager.isSellable((cursor = event.getCursor()).getType())) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.not-sellable", "<red>\u274c This item cannot be sold!", new LanguageManager.ComponentPlaceholder[0]));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
            event.setCancelled(true);
            return;
        }
        if (event.getClickedInventory() == topInv) {
            return;
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        ItemStack item;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory topInv = event.getView().getTopInventory();
        if (topInv == null || !event.getView().title().toString().contains("Sell Items")) {
            return;
        }
        if (event.getRawSlots().stream().anyMatch(slot -> slot < topInv.getSize()) && (item = event.getOldCursor()) != null && !this.guiManager.isSellable(item.getType())) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.not-sellable", "<red>\u274c This item cannot be sold!", new LanguageManager.ComponentPlaceholder[0]));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inv = event.getInventory();
        if (inv == null || !event.getView().title().toString().contains("Sell Items")) {
            return;
        }
        this.guiManager.processSellAndReturnItems(player, inv);
    }
}

