/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.sellgui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.commands.config.SellConfig;
import net.lunark.io.economy.ServerEssentialsEconomy;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.sellgui.SellStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SellGUIManager
implements Listener {
    private static final MiniMessage mini = MiniMessage.miniMessage();
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final SellStorage storage;
    private final SellConfig config;
    private final ServerEssentialsEconomy economy;
    private final Map<UUID, Double> pendingValues = new HashMap<UUID, Double>();
    private final DecimalFormat formatter = new DecimalFormat("#,##0.00");
    private final Set<Inventory> sellInventories = new HashSet<Inventory>();

    public SellGUIManager(Plugin plugin, PlayerLanguageManager langManager, SellStorage storage, SellConfig config, ServerEssentialsEconomy economy) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.economy = economy;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void openSellGUI(Player player) {
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.disabled", "<red>The sell GUI is currently disabled.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        Component title = this.langManager.getMessageFor(player, "economy.sellgui.title", "<gold>\ud83d\udcb0 Sell Items", new LanguageManager.ComponentPlaceholder[0]);
        Inventory inv = Bukkit.createInventory(null, (int)this.config.guiSize, (Component)title);
        this.createBorder(inv);
        this.createInfoPanel(player, inv);
        player.openInventory(inv);
        this.pendingValues.put(player.getUniqueId(), 0.0);
        this.sellInventories.add(inv);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.5f, 1.0f);
    }

    private void createBorder(Inventory inv) {
        for (int i = 0; i < inv.getSize(); ++i) {
            if (i >= 9 && i < inv.getSize() - 9 && i % 9 != 0 && i % 9 != 8) continue;
            ItemStack pane = new ItemStack(Material.CYAN_STAINED_GLASS_PANE);
            ItemMeta meta = pane.getItemMeta();
            if (meta != null) {
                meta.displayName(mini.deserialize(" "));
                meta.getPersistentDataContainer().set(new NamespacedKey(this.plugin, "sellgui_display"), PersistentDataType.BYTE, (Object)1);
                pane.setItemMeta(meta);
            }
            inv.setItem(i, pane);
        }
    }

    private void createInfoPanel(Player player, Inventory inv) {
        ItemStack emerald = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta meta = emerald.getItemMeta();
        if (meta != null) {
            meta.displayName(this.langManager.getMessageFor(player, "economy.sellgui.info.title", "<green><bold>\u2713 SELL ZONE", new LanguageManager.ComponentPlaceholder[0]));
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(this.langManager.getMessageFor(player, "economy.sellgui.info.subtitle", "<gray>Place items here to sell", new LanguageManager.ComponentPlaceholder[0]));
            lore.add(this.langManager.getMessageFor(player, "economy.sellgui.info.instruction", "<gray>Close inventory to process", new LanguageManager.ComponentPlaceholder[0]));
            lore.add(Component.empty());
            lore.add(this.langManager.getMessageFor(player, "economy.sellgui.info.value-prefix", "<gold>Total Value: <yellow>$0.00", new LanguageManager.ComponentPlaceholder[0]));
            meta.lore(lore);
            meta.getPersistentDataContainer().set(new NamespacedKey(this.plugin, "sellgui_display"), PersistentDataType.BYTE, (Object)1);
            emerald.setItemMeta(meta);
        }
        inv.setItem(inv.getSize() - 5, emerald);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int slot;
        if (!this.sellInventories.contains(event.getInventory())) {
            return;
        }
        if (event.getCurrentItem() != null && this.isDisplayItem(event.getCurrentItem())) {
            event.setCancelled(true);
            return;
        }
        if (event.getClick().isShiftClick() && event.getClickedInventory() == event.getInventory() && ((slot = event.getSlot()) < 9 || slot >= event.getInventory().getSize() - 9 || slot % 9 == 0 || slot % 9 == 8)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!this.sellInventories.contains(event.getInventory())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot >= 9 && slot < event.getInventory().getSize() - 9 && slot % 9 != 0 && slot % 9 != 8) continue;
            event.setCancelled(true);
            return;
        }
    }

    private boolean isDisplayItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.getPersistentDataContainer().has(new NamespacedKey(this.plugin, "sellgui_display"), PersistentDataType.BYTE);
    }

    public boolean isSellable(Material material) {
        return this.config.isSellable(material);
    }

    public void updateValueDisplay(Player player, Inventory inv, double totalValue) {
        List lore;
        ItemMeta meta;
        int centerSlot = inv.getSize() - 5;
        ItemStack item = inv.getItem(centerSlot);
        if (item != null && item.getType() == Material.EMERALD_BLOCK && (meta = item.getItemMeta()) != null && meta.hasLore() && (lore = meta.lore()).size() >= 4) {
            String valuePrefix = this.langManager.getMessageFor(player, "economy.sellgui.info.value-prefix", "<gold>Total Value: <yellow>", new LanguageManager.ComponentPlaceholder[0]).toString().replaceAll("\\$0.00$", "");
            lore.set(3, mini.deserialize(valuePrefix + this.formatter.format(totalValue)));
            meta.lore(lore);
            item.setItemMeta(meta);
        }
    }

    public void processSellAndReturnItems(Player player, Inventory inv) {
        UUID uuid = player.getUniqueId();
        HashMap<Integer, ItemStack> itemsToReturn = new HashMap<Integer, ItemStack>();
        double totalValue = 0.0;
        int itemsSold = 0;
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item2 = inv.getItem(i);
            if (item2 == null || item2.getType() == Material.AIR || i < 9 || i >= inv.getSize() - 9 || i % 9 == 0 || i % 9 == 8 || item2.getType() == Material.CYAN_STAINED_GLASS_PANE || item2.getType() == Material.EMERALD_BLOCK) continue;
            Material mat = item2.getType();
            double pricePerItem = this.config.getSellPrice(mat);
            if (pricePerItem > 0.0) {
                int amount = item2.getAmount();
                double itemValue = pricePerItem * (double)amount;
                totalValue += itemValue;
                itemsSold += amount;
                this.storage.logSale(uuid, player.getName(), mat, amount, pricePerItem, itemValue);
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.3f, 1.5f);
                continue;
            }
            itemsToReturn.put(i, item2.clone());
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.4f, 0.8f);
        }
        if (totalValue > 0.0) {
            this.economy.depositPlayer((OfflinePlayer)player, totalValue);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.0f);
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.sold-success", "<green><bold>\u2713 SOLD</bold> <white>{amount}x items</white> for <gold>{symbol}{price}", LanguageManager.ComponentPlaceholder.of("{amount}", String.valueOf(itemsSold)), LanguageManager.ComponentPlaceholder.of("{symbol}", this.config.currencySymbol), LanguageManager.ComponentPlaceholder.of("{price}", this.formatter.format(totalValue))));
        }
        if (!itemsToReturn.isEmpty()) {
            HashMap leftOver = player.getInventory().addItem(itemsToReturn.values().toArray(new ItemStack[0]));
            if (!leftOver.isEmpty()) {
                leftOver.values().forEach(item -> player.getWorld().dropItemNaturally(player.getLocation(), item));
                player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.inventory-full", "<yellow>\u26a0 Some items were dropped on the ground (inventory full)", new LanguageManager.ComponentPlaceholder[0]));
            }
            if (totalValue == 0.0) {
                player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.returned-items", "<gray>Returned <white>{amount}x unsellable items</white> to your inventory", LanguageManager.ComponentPlaceholder.of("{amount}", String.valueOf(itemsToReturn.size()))));
            }
        }
        this.pendingValues.remove(uuid);
        this.sellInventories.remove(inv);
        if (totalValue == 0.0 && itemsToReturn.isEmpty()) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.no-items", "<gray>No items were sold", new LanguageManager.ComponentPlaceholder[0]));
        }
    }
}

