/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.serverEssentials;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionChecker {
    private static final String MODRINTH_PROJECT_ID = "K7HZMVgx";
    private static String latestVersion = "unknown";
    private static final MiniMessage MINI = MiniMessage.miniMessage();

    public static void checkLatestVersion(Plugin plugin) {
        HttpClient client = HttpClient.newHttpClient();
        String url = "https://api.modrinth.com/v2/project/K7HZMVgx/version";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(response -> {
            try {
                JSONArray versions = new JSONArray((String)response);
                if (versions.length() > 0) {
                    JSONObject latest = versions.getJSONObject(0);
                    latestVersion = latest.getString("version_number");
                    String currentVersion = plugin.getDescription().getVersion();
                    Bukkit.getLogger().info("");
                    Bukkit.getLogger().info("\u00a78================================");
                    if (!currentVersion.equalsIgnoreCase(latestVersion)) {
                        Bukkit.getLogger().info("\u00a7eServerEssentials \u00a77- \u00a76Update Available");
                        Bukkit.getLogger().info("\u00a78--------------------------------");
                        Bukkit.getLogger().info("\u00a77Current: \u00a7c" + currentVersion);
                        Bukkit.getLogger().info("\u00a77Latest: \u00a7a" + latestVersion);
                        Bukkit.getLogger().info("\u00a77Download: \u00a7bhttps://modrinth.com/plugin/serveressentials");
                    } else {
                        Bukkit.getLogger().info("\u00a7eServerEssentials \u00a77- \u00a7aUp To Date");
                        Bukkit.getLogger().info("\u00a78--------------------------------");
                        Bukkit.getLogger().info("\u00a77Running latest version: \u00a7a" + currentVersion);
                    }
                    Bukkit.getLogger().info("\u00a78================================");
                    Bukkit.getLogger().info("");
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("\u00a78================================");
                Bukkit.getLogger().warning("\u00a7cFailed to parse version data from Modrinth.");
                Bukkit.getLogger().warning("\u00a78================================");
            }
        })).exceptionally(e -> {
            Bukkit.getLogger().warning("\u00a78================================");
            Bukkit.getLogger().warning("\u00a7cCould not fetch latest version from Modrinth.");
            Bukkit.getLogger().warning("\u00a78================================");
            return null;
        });
    }

    public static void notifyIfOutdated(Player player) {
        String currentVersion = ServerEssentials.getInstance().getDescription().getVersion();
        String latest = VersionChecker.getLatestVersion();
        if (!latest.equals("unknown") && !currentVersion.equals(latest) && (player.hasPermission("serveressentials.version.notify") || player.isOp())) {
            player.sendMessage(MINI.deserialize("<gray> </gray>"));
            player.sendMessage(MINI.deserialize("<gray>8================================</gray>"));
            player.sendMessage(MINI.deserialize("<gradient:#FFCC33:#FFF2AA>ServerEssentials - Update Available</gradient>"));
            player.sendMessage(MINI.deserialize("<gray>--------------------------------</gray>"));
            player.sendMessage(MINI.deserialize("<gray>Current: </gray><red>" + currentVersion + "</red>"));
            player.sendMessage(MINI.deserialize("<gray>Latest: </gray><green>" + latest + "</green>"));
            player.sendMessage(MINI.deserialize("<gray>Download: </gray><aqua>https://modrinth.com/plugin/serveressentials</aqua>"));
            player.sendMessage(MINI.deserialize("<gray>================================</gray>"));
            player.sendMessage(MINI.deserialize("<gray> </gray>"));
        }
    }

    public static String getCurrentVersion() {
        return ServerEssentials.getInstance().getDescription().getVersion();
    }

    public static String getLatestVersion() {
        return latestVersion;
    }
}

