/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ReloadUtils {
    public static FileConfiguration reloadFile(File file) {
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static List<File> getAllYmlFiles(File folder) {
        ArrayList<File> result = new ArrayList<File>();
        if (folder == null || !folder.exists()) {
            return result;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return result;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                result.addAll(ReloadUtils.getAllYmlFiles(f));
                continue;
            }
            if (!f.getName().toLowerCase().endsWith(".yml")) continue;
            result.add(f);
        }
        return result;
    }

    public static int reloadAllInDirectory(File folder) {
        int count = 0;
        for (File f : ReloadUtils.getAllYmlFiles(folder)) {
            try {
                ReloadUtils.reloadFile(f);
                ++count;
            }
            catch (Exception e) {
                System.err.println("[ServerEssentials] Failed to reload " + f.getName() + ": " + e.getMessage());
            }
        }
        return count;
    }

    public static void ensureExists(File file) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

