/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.vault;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.vault.VaultStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VaultManager
implements Listener {
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final VaultStorage storage;
    private final Map<UUID, VaultSession> editingVaults = new HashMap<UUID, VaultSession>();

    public VaultManager(JavaPlugin plugin, PlayerLanguageManager langManager, VaultStorage storage) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openVault(Player player, int number) {
        if (!this.isValidVaultNumber(number)) {
            player.sendMessage(this.langManager.getMessageFor(player, "vault.invalid-number", "<red>Invalid vault number! Must be 1-10.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        String perm = "serveressentials.command.vault." + number;
        if (!player.hasPermission(perm)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", perm)));
            return;
        }
        Component title = this.langManager.getMessageFor(player, "vault.title", "<green>Vault <white>#{number}", LanguageManager.ComponentPlaceholder.of("{number}", String.valueOf(number)));
        Inventory inv = Bukkit.createInventory(null, (int)54, (Component)title);
        ((CompletableFuture)this.storage.loadVaultData(player.getUniqueId(), number).thenAccept(optData -> {
            if (optData.isPresent()) {
                this.storage.deserializeInventory(inv, (String)optData.get());
            }
        })).thenRun(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            player.openInventory(inv);
            player.setMetadata("vault_id", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)number));
        }));
    }

    public void openVaultAsAdmin(Player admin, UUID targetUUID, String targetName, int number, boolean previewOnly) {
        if (!this.isValidVaultNumber(number)) {
            admin.sendMessage(this.langManager.getMessageFor(admin, "vault.invalid-number", "<red>Invalid vault number! Must be 1-10.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        Component title = this.langManager.getMessageFor(admin, previewOnly ? "vault.admin-preview" : "vault.admin-edit", previewOnly ? "<yellow>Viewing <white>{player}'s <yellow>Vault #{number}" : "<red>Editing <white>{player}'s <red>Vault #{number}", LanguageManager.ComponentPlaceholder.of("{player}", targetName), LanguageManager.ComponentPlaceholder.of("{number}", String.valueOf(number)));
        Inventory inv = Bukkit.createInventory(null, (int)54, (Component)title);
        ((CompletableFuture)this.storage.loadVaultData(targetUUID, number).thenAccept(optData -> {
            if (optData.isPresent()) {
                this.storage.deserializeInventory(inv, (String)optData.get());
            }
        })).thenRun(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            admin.openInventory(inv);
            if (!previewOnly) {
                this.editingVaults.put(admin.getUniqueId(), new VaultSession(targetUUID, number));
                admin.setMetadata("editing_vault", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            }
        }));
    }

    @EventHandler
    public void onVaultClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inv = event.getInventory();
        if (player.hasMetadata("vault_id")) {
            int vaultId = ((MetadataValue)player.getMetadata("vault_id").get(0)).asInt();
            player.removeMetadata("vault_id", (Plugin)this.plugin);
            this.storage.saveVault(player.getUniqueId(), vaultId, inv).thenRun(() -> player.sendMessage(this.langManager.getMessageFor(player, "vault.saved", "<green>Vault <yellow>{vault}</yellow> saved!", LanguageManager.ComponentPlaceholder.of("{vault}", String.valueOf(vaultId)))));
        } else if (player.hasMetadata("editing_vault")) {
            VaultSession session = this.editingVaults.remove(player.getUniqueId());
            if (session != null) {
                this.storage.saveVault(session.targetUUID, session.vaultNumber, inv).thenRun(() -> {
                    String targetName = Bukkit.getOfflinePlayer((UUID)session.targetUUID).getName();
                    player.sendMessage(this.langManager.getMessageFor(player, "vault.admin-saved", "<green>Saved vault <yellow>{vault}</yellow> for <yellow>{player}</yellow>!", LanguageManager.ComponentPlaceholder.of("{vault}", String.valueOf(session.vaultNumber)), LanguageManager.ComponentPlaceholder.of("{player}", targetName != null ? targetName : "Unknown")));
                });
            }
            player.removeMetadata("editing_vault", (Plugin)this.plugin);
        }
    }

    public CompletableFuture<Void> clearVault(UUID uuid, int number) {
        return this.storage.clearVault(uuid, number);
    }

    public CompletableFuture<Boolean> hasVault(UUID uuid, int number) {
        return this.storage.hasVault(uuid, number);
    }

    private boolean isValidVaultNumber(int number) {
        return number >= 1 && number <= 10;
    }

    private static class VaultSession {
        public final UUID targetUUID;
        public final int vaultNumber;

        public VaultSession(UUID targetUUID, int vaultNumber) {
            this.targetUUID = targetUUID;
            this.vaultNumber = vaultNumber;
        }
    }
}

