/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.InternalApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.Storage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationInfo
implements Serializable {
    private static final long serialVersionUID = -996243512290027661L;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/topics/{topic}");
    private final String notificationId;
    private final String topic;
    private final List<EventType> eventTypes;
    private final Map<String, String> customAttributes;
    private final PayloadFormat payloadFormat;
    private final String objectNamePrefix;
    private final String etag;
    private final String selfLink;
    private final String bucket;

    NotificationInfo(BuilderImpl builder) {
        this.notificationId = builder.notificationId;
        this.etag = builder.etag;
        this.selfLink = builder.selfLink;
        this.topic = builder.topic;
        this.eventTypes = builder.eventTypes;
        this.customAttributes = builder.customAttributes;
        this.payloadFormat = builder.payloadFormat;
        this.objectNamePrefix = builder.objectNamePrefix;
        this.bucket = builder.bucket;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public PayloadFormat getPayloadFormat() {
        return this.payloadFormat;
    }

    public String getObjectNamePrefix() {
        return this.objectNamePrefix;
    }

    public String getEtag() {
        return this.etag;
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    @InternalApi
    String getBucket() {
        return this.bucket;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.notificationId, this.topic, this.eventTypes, this.customAttributes, this.payloadFormat, this.objectNamePrefix, this.etag, this.selfLink});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationInfo)) {
            return false;
        }
        NotificationInfo that = (NotificationInfo)o;
        return Objects.equals(this.notificationId, that.notificationId) && Objects.equals(this.topic, that.topic) && Objects.equals(this.eventTypes, that.eventTypes) && Objects.equals(this.customAttributes, that.customAttributes) && this.payloadFormat == that.payloadFormat && Objects.equals(this.objectNamePrefix, that.objectNamePrefix) && Objects.equals(this.etag, that.etag) && Objects.equals(this.selfLink, that.selfLink);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("topic", this.topic).toString();
    }

    public static NotificationInfo of(String topic) {
        NotificationInfo.checkTopicFormat(topic);
        return NotificationInfo.newBuilder(topic).build();
    }

    public static Builder newBuilder(String topic) {
        NotificationInfo.checkTopicFormat(topic);
        return new BuilderImpl(topic);
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    Notification asNotification(Storage storage) {
        return new Notification(storage, new BuilderImpl(this));
    }

    private static void checkTopicFormat(String topic) {
        PATH_TEMPLATE.validatedMatch(topic, "topic name must be in valid format");
    }

    public static class BuilderImpl
    extends Builder {
        private String notificationId;
        private String topic;
        private List<EventType> eventTypes;
        private Map<String, String> customAttributes;
        private PayloadFormat payloadFormat;
        private String objectNamePrefix;
        private String etag;
        private String selfLink;
        private String bucket;

        BuilderImpl(String topic) {
            this.topic = topic;
        }

        BuilderImpl(NotificationInfo notificationInfo) {
            this.notificationId = notificationInfo.notificationId;
            this.etag = notificationInfo.etag;
            this.selfLink = notificationInfo.selfLink;
            this.topic = notificationInfo.topic;
            this.eventTypes = notificationInfo.eventTypes;
            this.customAttributes = notificationInfo.customAttributes;
            this.payloadFormat = notificationInfo.payloadFormat;
            this.objectNamePrefix = notificationInfo.objectNamePrefix;
            this.bucket = notificationInfo.bucket;
        }

        @Override
        Builder setNotificationId(String notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        @Override
        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public Builder setPayloadFormat(PayloadFormat payloadFormat) {
            this.payloadFormat = payloadFormat;
            return this;
        }

        @Override
        public Builder setObjectNamePrefix(String objectNamePrefix) {
            this.objectNamePrefix = objectNamePrefix;
            return this;
        }

        @Override
        public Builder setEventTypes(EventType ... eventTypes) {
            this.eventTypes = eventTypes != null ? Arrays.asList(eventTypes) : null;
            return this;
        }

        @Override
        public Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder setCustomAttributes(Map<String, String> customAttributes) {
            this.customAttributes = customAttributes != null ? ImmutableMap.copyOf(customAttributes) : null;
            return this;
        }

        @Override
        Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public NotificationInfo build() {
            Preconditions.checkNotNull(this.topic);
            NotificationInfo.checkTopicFormat(this.topic);
            return new NotificationInfo(this);
        }
    }

    public static abstract class Builder {
        Builder() {
        }

        abstract Builder setNotificationId(String var1);

        public abstract Builder setSelfLink(String var1);

        public abstract Builder setTopic(String var1);

        public abstract Builder setPayloadFormat(PayloadFormat var1);

        public abstract Builder setObjectNamePrefix(String var1);

        public abstract Builder setEventTypes(EventType ... var1);

        public abstract Builder setEtag(String var1);

        public abstract Builder setCustomAttributes(Map<String, String> var1);

        abstract Builder setBucket(String var1);

        public abstract NotificationInfo build();
    }

    public static enum EventType {
        OBJECT_FINALIZE,
        OBJECT_METADATA_UPDATE,
        OBJECT_DELETE,
        OBJECT_ARCHIVE;

    }

    public static enum PayloadFormat {
        JSON_API_V1,
        NONE;

    }
}

