/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class ProviderConfig {
    @Key(value="name")
    private String resourceName;
    @Key(value="displayName")
    private String displayName;
    @Key(value="enabled")
    private boolean enabled;

    public String getProviderId() {
        return this.resourceName.substring(this.resourceName.lastIndexOf("/") + 1);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static void assertValidUrl(String url) throws IllegalArgumentException {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url + " is a malformed URL.", e);
        }
    }

    public static abstract class AbstractUpdateRequest<T extends AbstractUpdateRequest<T>> {
        final String providerId;
        final Map<String, Object> properties = new HashMap<String, Object>();

        AbstractUpdateRequest(String providerId) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(providerId), "Provider ID must not be null or empty.");
            this.providerId = providerId;
        }

        String getProviderId() {
            return this.providerId;
        }

        public T setDisplayName(String displayName) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(displayName), "Display name must not be null or empty.");
            this.properties.put("displayName", displayName);
            return this.getThis();
        }

        public T setEnabled(boolean enabled) {
            this.properties.put("enabled", enabled);
            return this.getThis();
        }

        Map<String, Object> getProperties() {
            return ImmutableMap.copyOf(this.properties);
        }

        abstract T getThis();
    }

    public static abstract class AbstractCreateRequest<T extends AbstractCreateRequest<T>> {
        final Map<String, Object> properties = new HashMap<String, Object>();
        String providerId;

        T setProviderId(String providerId) {
            this.providerId = providerId;
            return this.getThis();
        }

        String getProviderId() {
            return this.providerId;
        }

        public T setDisplayName(String displayName) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(displayName), "Display name must not be null or empty.");
            this.properties.put("displayName", displayName);
            return this.getThis();
        }

        public T setEnabled(boolean enabled) {
            this.properties.put("enabled", enabled);
            return this.getThis();
        }

        Map<String, Object> getProperties() {
            return ImmutableMap.copyOf(this.properties);
        }

        abstract T getThis();
    }
}

