/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.ErrorCode;
import com.google.firebase.auth.AuthErrorCode;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.FirebaseTokenVerifier;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.UserRecord;

class RevocationCheckDecorator
implements FirebaseTokenVerifier {
    private final FirebaseTokenVerifier tokenVerifier;
    private final FirebaseUserManager userManager;
    private final AuthErrorCode errorCode;
    private final String shortName;

    private RevocationCheckDecorator(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager, AuthErrorCode errorCode, String shortName) {
        this.tokenVerifier = Preconditions.checkNotNull(tokenVerifier);
        this.userManager = Preconditions.checkNotNull(userManager);
        this.errorCode = Preconditions.checkNotNull(errorCode);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(shortName));
        this.shortName = shortName;
    }

    @Override
    public FirebaseToken verifyToken(String token) throws FirebaseAuthException {
        FirebaseToken firebaseToken = this.tokenVerifier.verifyToken(token);
        this.validateDisabledOrRevoked(firebaseToken);
        return firebaseToken;
    }

    private void validateDisabledOrRevoked(FirebaseToken firebaseToken) throws FirebaseAuthException {
        UserRecord user = this.userManager.getUserById(firebaseToken.getUid());
        if (user.isDisabled()) {
            throw new FirebaseAuthException(ErrorCode.INVALID_ARGUMENT, "The user record is disabled.", null, null, AuthErrorCode.USER_DISABLED);
        }
        long issuedAtInSeconds = (Long)firebaseToken.getClaims().get("iat");
        if (user.getTokensValidAfterTimestamp() > issuedAtInSeconds * 1000L) {
            throw new FirebaseAuthException(ErrorCode.INVALID_ARGUMENT, "Firebase " + this.shortName + " is revoked.", null, null, this.errorCode);
        }
    }

    static RevocationCheckDecorator decorateIdTokenVerifier(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager) {
        return new RevocationCheckDecorator(tokenVerifier, userManager, AuthErrorCode.REVOKED_ID_TOKEN, "id token");
    }

    static RevocationCheckDecorator decorateSessionCookieVerifier(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager) {
        return new RevocationCheckDecorator(tokenVerifier, userManager, AuthErrorCode.REVOKED_SESSION_COOKIE, "session cookie");
    }
}

