/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.JsonFactory;
import com.google.common.collect.ImmutableSortedSet;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.internal.AuthErrorHandler;
import com.google.firebase.internal.ErrorHandlingHttpClient;
import com.google.firebase.internal.HttpRequestInfo;
import com.google.firebase.internal.SdkUtils;
import java.util.Map;
import java.util.Set;

public final class AuthHttpClient {
    private static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    private static final String CLIENT_VERSION = "Java/Admin/" + SdkUtils.getVersion();
    private final ErrorHandlingHttpClient<FirebaseAuthException> httpClient;
    private final JsonFactory jsonFactory;

    public AuthHttpClient(JsonFactory jsonFactory, HttpRequestFactory requestFactory) {
        AuthErrorHandler authErrorHandler = new AuthErrorHandler(jsonFactory);
        this.httpClient = new ErrorHandlingHttpClient<FirebaseAuthException>(requestFactory, jsonFactory, authErrorHandler);
        this.jsonFactory = jsonFactory;
    }

    public static Set<String> generateMask(Map<String, Object> properties) {
        ImmutableSortedSet.Builder maskBuilder = ImmutableSortedSet.naturalOrder();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Set<String> childMask = AuthHttpClient.generateMask((Map)entry.getValue());
                for (String childProperty : childMask) {
                    maskBuilder.add(entry.getKey() + "." + childProperty);
                }
                continue;
            }
            maskBuilder.add(entry.getKey());
        }
        return maskBuilder.build();
    }

    public void setInterceptor(HttpResponseInterceptor interceptor) {
        this.httpClient.setInterceptor(interceptor);
    }

    public <T> T sendRequest(HttpRequestInfo request, Class<T> clazz) throws FirebaseAuthException {
        IncomingHttpResponse response = this.sendRequest(request);
        return this.parse(response, clazz);
    }

    public IncomingHttpResponse sendRequest(HttpRequestInfo request) throws FirebaseAuthException {
        request.addHeader(CLIENT_VERSION_HEADER, CLIENT_VERSION);
        return this.httpClient.send(request);
    }

    public <T> T parse(IncomingHttpResponse response, Class<T> clazz) throws FirebaseAuthException {
        return this.httpClient.parse(response, clazz);
    }
}

