/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.multitenancy;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.internal.AuthHttpClient;
import com.google.firebase.auth.internal.ListTenantsResponse;
import com.google.firebase.auth.internal.Utils;
import com.google.firebase.auth.multitenancy.Tenant;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.HttpRequestInfo;
import java.util.Map;

final class FirebaseTenantClient {
    static final int MAX_LIST_TENANTS_RESULTS = 100;
    private static final String ID_TOOLKIT_URL = "https://identitytoolkit.googleapis.com/%s/projects/%s";
    private static final String ID_TOOLKIT_URL_EMULATOR = "http://%s/identitytoolkit.googleapis.com/%s/projects/%s";
    private final String tenantMgtBaseUrl;
    private final AuthHttpClient httpClient;

    FirebaseTenantClient(FirebaseApp app) {
        this(ImplFirebaseTrampolines.getProjectId(Preconditions.checkNotNull(app)), app.getOptions().getJsonFactory(), ApiClientUtils.newAuthorizedRequestFactory(app));
    }

    FirebaseTenantClient(String projectId, JsonFactory jsonFactory, HttpRequestFactory requestFactory) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(projectId), "Project ID is required to access the auth service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        this.tenantMgtBaseUrl = this.getTenantMgtBaseUrl(projectId);
        this.httpClient = new AuthHttpClient(jsonFactory, requestFactory);
    }

    private String getTenantMgtBaseUrl(String projectId) {
        if (Utils.isEmulatorMode()) {
            return String.format(ID_TOOLKIT_URL_EMULATOR, Utils.getEmulatorHost(), "v2", projectId);
        }
        return String.format(ID_TOOLKIT_URL, "v2", projectId);
    }

    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.httpClient.setInterceptor(interceptor);
    }

    Tenant getTenant(String tenantId) throws FirebaseAuthException {
        String url = this.tenantMgtBaseUrl + FirebaseTenantClient.getTenantUrlSuffix(tenantId);
        return this.httpClient.sendRequest(HttpRequestInfo.buildGetRequest(url), Tenant.class);
    }

    Tenant createTenant(Tenant.CreateRequest request) throws FirebaseAuthException {
        String url = this.tenantMgtBaseUrl + "/tenants";
        return this.httpClient.sendRequest(HttpRequestInfo.buildJsonPostRequest(url, request.getProperties()), Tenant.class);
    }

    Tenant updateTenant(Tenant.UpdateRequest request) throws FirebaseAuthException {
        Map<String, Object> properties = request.getProperties();
        String url = this.tenantMgtBaseUrl + FirebaseTenantClient.getTenantUrlSuffix(request.getTenantId());
        HttpRequestInfo requestInfo = HttpRequestInfo.buildJsonPatchRequest(url, properties).addParameter("updateMask", Joiner.on(",").join(AuthHttpClient.generateMask(properties)));
        return this.httpClient.sendRequest(requestInfo, Tenant.class);
    }

    void deleteTenant(String tenantId) throws FirebaseAuthException {
        String url = this.tenantMgtBaseUrl + FirebaseTenantClient.getTenantUrlSuffix(tenantId);
        this.httpClient.sendRequest(HttpRequestInfo.buildDeleteRequest(url), GenericJson.class);
    }

    ListTenantsResponse listTenants(int maxResults, String pageToken) throws FirebaseAuthException {
        ImmutableMap.Builder<String, Integer> builder = ImmutableMap.builder().put("pageSize", maxResults);
        if (pageToken != null) {
            Preconditions.checkArgument(!pageToken.equals(""), "Invalid end of list page token.");
            builder.put("pageToken", (Integer)((Object)pageToken));
        }
        HttpRequestInfo requestInfo = HttpRequestInfo.buildGetRequest(this.tenantMgtBaseUrl + "/tenants").addAllParameters(builder.build());
        return this.httpClient.sendRequest(requestInfo, ListTenantsResponse.class);
    }

    private static String getTenantUrlSuffix(String tenantId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(tenantId), "Tenant ID must not be null or empty.");
        return "/tenants/" + tenantId;
    }
}

