/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.util.GAuthToken;
import java.util.Map;
import java.util.concurrent.Executor;

public class JvmAuthTokenProvider
implements AuthTokenProvider {
    private final GoogleCredentials credentials;
    private final Map<String, Object> authVariable;
    private final Executor executor;

    JvmAuthTokenProvider(FirebaseApp firebaseApp, Executor executor) {
        this(firebaseApp, executor, true);
    }

    JvmAuthTokenProvider(FirebaseApp firebaseApp, Executor executor, boolean autoRefresh) {
        this(firebaseApp, executor, autoRefresh, ImplFirebaseTrampolines.getCredentials(firebaseApp));
    }

    JvmAuthTokenProvider(FirebaseApp firebaseApp, Executor executor, boolean autoRefresh, GoogleCredentials customCredentials) {
        this.credentials = customCredentials;
        this.authVariable = firebaseApp.getOptions().getDatabaseAuthVariableOverride();
        this.executor = executor;
        if (autoRefresh) {
            ImplFirebaseTrampolines.startTokenRefresher(firebaseApp);
        }
    }

    @Override
    public void getToken(boolean forceRefresh, AuthTokenProvider.GetTokenCompletionListener listener) {
        try {
            if (forceRefresh) {
                this.credentials.refresh();
            }
            this.credentials.getRequestMetadata();
            AccessToken accessToken = this.credentials.getAccessToken();
            listener.onSuccess(JvmAuthTokenProvider.wrapOAuthToken(accessToken, this.authVariable));
        }
        catch (Exception e) {
            listener.onError(e.toString());
        }
    }

    @Override
    public void addTokenChangeListener(AuthTokenProvider.TokenChangeListener listener) {
        TokenChangeListenerWrapper listenerWrapper = new TokenChangeListenerWrapper(listener, this.executor, this.authVariable);
        this.credentials.addChangeListener(listenerWrapper);
    }

    private static String wrapOAuthToken(AccessToken result, Map<String, Object> authVariable) {
        if (result == null) {
            return null;
        }
        GAuthToken googleAuthToken = new GAuthToken(result.getTokenValue(), authVariable);
        return googleAuthToken.serializeToString();
    }

    private static class TokenChangeListenerWrapper
    implements OAuth2Credentials.CredentialsChangedListener {
        private final AuthTokenProvider.TokenChangeListener listener;
        private final Executor executor;
        private final Map<String, Object> authVariable;

        TokenChangeListenerWrapper(AuthTokenProvider.TokenChangeListener listener, Executor executor, Map<String, Object> authVariable) {
            this.listener = Preconditions.checkNotNull(listener, "Listener must not be null");
            this.executor = Preconditions.checkNotNull(executor, "Executor must not be null");
            this.authVariable = authVariable;
        }

        @Override
        public void onChanged(OAuth2Credentials credentials) {
            final AccessToken accessToken = credentials.getAccessToken();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.onTokenChange(JvmAuthTokenProvider.wrapOAuthToken(accessToken, authVariable));
                }
            });
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof TokenChangeListenerWrapper && ((TokenChangeListenerWrapper)obj).listener.equals(this.listener);
        }
    }
}

