/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.persistence;

import com.google.firebase.database.core.CompoundWrite;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.UserWriteRecord;
import com.google.firebase.database.core.persistence.CachePolicy;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.core.persistence.PersistenceStorageEngine;
import com.google.firebase.database.core.persistence.PruneForest;
import com.google.firebase.database.core.persistence.TrackedQuery;
import com.google.firebase.database.core.persistence.TrackedQueryManager;
import com.google.firebase.database.core.view.CacheNode;
import com.google.firebase.database.core.view.QuerySpec;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.utilities.Clock;
import com.google.firebase.database.utilities.DefaultClock;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistenceManager
implements PersistenceManager {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceManager.class);
    private final PersistenceStorageEngine storageLayer;
    private final TrackedQueryManager trackedQueryManager;
    private final CachePolicy cachePolicy;
    private long serverCacheUpdatesSinceLastPruneCheck = 0L;

    public DefaultPersistenceManager(PersistenceStorageEngine engine, CachePolicy cachePolicy) {
        this(engine, cachePolicy, new DefaultClock());
    }

    public DefaultPersistenceManager(PersistenceStorageEngine engine, CachePolicy cachePolicy, Clock clock) {
        this.storageLayer = engine;
        this.trackedQueryManager = new TrackedQueryManager(this.storageLayer, logger, clock);
        this.cachePolicy = cachePolicy;
    }

    @Override
    public void saveUserOverwrite(Path path, Node node, long writeId) {
        this.storageLayer.saveUserOverwrite(path, node, writeId);
    }

    @Override
    public void saveUserMerge(Path path, CompoundWrite children, long writeId) {
        this.storageLayer.saveUserMerge(path, children, writeId);
    }

    @Override
    public void removeUserWrite(long writeId) {
        this.storageLayer.removeUserWrite(writeId);
    }

    @Override
    public void removeAllUserWrites() {
        this.storageLayer.removeAllUserWrites();
    }

    @Override
    public void applyUserWriteToServerCache(Path path, Node node) {
        if (!this.trackedQueryManager.hasActiveDefaultQuery(path)) {
            this.storageLayer.overwriteServerCache(path, node);
            this.trackedQueryManager.ensureCompleteTrackedQuery(path);
        }
    }

    @Override
    public void applyUserWriteToServerCache(Path path, CompoundWrite merge) {
        for (Map.Entry<Path, Node> write : merge) {
            Path writePath = path.child(write.getKey());
            Node writeNode = write.getValue();
            this.applyUserWriteToServerCache(writePath, writeNode);
        }
    }

    @Override
    public List<UserWriteRecord> loadUserWrites() {
        return this.storageLayer.loadUserWrites();
    }

    @Override
    public CacheNode serverCache(QuerySpec query) {
        Set<ChildKey> trackedKeys;
        boolean complete;
        if (this.trackedQueryManager.isQueryComplete(query)) {
            complete = true;
            TrackedQuery trackedQuery = this.trackedQueryManager.findTrackedQuery(query);
            trackedKeys = !query.loadsAllData() && trackedQuery != null && trackedQuery.complete ? this.storageLayer.loadTrackedQueryKeys(trackedQuery.id) : null;
        } else {
            complete = false;
            trackedKeys = this.trackedQueryManager.getKnownCompleteChildren(query.getPath());
        }
        Node serverCacheNode = this.storageLayer.serverCache(query.getPath());
        if (trackedKeys != null) {
            Node filteredNode = EmptyNode.Empty();
            for (ChildKey key : trackedKeys) {
                filteredNode = filteredNode.updateImmediateChild(key, serverCacheNode.getImmediateChild(key));
            }
            return new CacheNode(IndexedNode.from(filteredNode, query.getIndex()), complete, true);
        }
        return new CacheNode(IndexedNode.from(serverCacheNode, query.getIndex()), complete, false);
    }

    @Override
    public void updateServerCache(QuerySpec query, Node node) {
        if (query.loadsAllData()) {
            this.storageLayer.overwriteServerCache(query.getPath(), node);
        } else {
            this.storageLayer.mergeIntoServerCache(query.getPath(), node);
        }
        this.setQueryComplete(query);
        this.doPruneCheckAfterServerUpdate();
    }

    @Override
    public void updateServerCache(Path path, CompoundWrite children) {
        this.storageLayer.mergeIntoServerCache(path, children);
        this.doPruneCheckAfterServerUpdate();
    }

    @Override
    public void setQueryActive(QuerySpec query) {
        this.trackedQueryManager.setQueryActive(query);
    }

    @Override
    public void setQueryInactive(QuerySpec query) {
        this.trackedQueryManager.setQueryInactive(query);
    }

    @Override
    public void setQueryComplete(QuerySpec query) {
        if (query.loadsAllData()) {
            this.trackedQueryManager.setQueriesComplete(query.getPath());
        } else {
            this.trackedQueryManager.setQueryCompleteIfExists(query);
        }
    }

    @Override
    public void setTrackedQueryKeys(QuerySpec query, Set<ChildKey> keys) {
        assert (!query.loadsAllData()) : "We should only track keys for filtered queries.";
        TrackedQuery trackedQuery = this.trackedQueryManager.findTrackedQuery(query);
        assert (trackedQuery != null && trackedQuery.active) : "We only expect tracked keys for currently-active queries.";
        this.storageLayer.saveTrackedQueryKeys(trackedQuery.id, keys);
    }

    @Override
    public void updateTrackedQueryKeys(QuerySpec query, Set<ChildKey> added, Set<ChildKey> removed) {
        assert (!query.loadsAllData()) : "We should only track keys for filtered queries.";
        TrackedQuery trackedQuery = this.trackedQueryManager.findTrackedQuery(query);
        assert (trackedQuery != null && trackedQuery.active) : "We only expect tracked keys for currently-active queries.";
        this.storageLayer.updateTrackedQueryKeys(trackedQuery.id, added, removed);
    }

    @Override
    public <T> T runInTransaction(Callable<T> callable) {
        this.storageLayer.beginTransaction();
        try {
            T result = callable.call();
            this.storageLayer.setTransactionSuccessful();
            T t2 = result;
            return t2;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.storageLayer.endTransaction();
        }
    }

    private void doPruneCheckAfterServerUpdate() {
        ++this.serverCacheUpdatesSinceLastPruneCheck;
        if (this.cachePolicy.shouldCheckCacheSize(this.serverCacheUpdatesSinceLastPruneCheck)) {
            logger.debug("Reached prune check threshold.");
            this.serverCacheUpdatesSinceLastPruneCheck = 0L;
            boolean canPrune = true;
            long cacheSize = this.storageLayer.serverCacheEstimatedSizeInBytes();
            logger.debug("Cache size: {}", (Object)cacheSize);
            while (canPrune && this.cachePolicy.shouldPrune(cacheSize, this.trackedQueryManager.countOfPrunableQueries())) {
                PruneForest pruneForest = this.trackedQueryManager.pruneOldQueries(this.cachePolicy);
                if (pruneForest.prunesAnything()) {
                    this.storageLayer.pruneCache(Path.getEmptyPath(), pruneForest);
                } else {
                    canPrune = false;
                }
                cacheSize = this.storageLayer.serverCacheEstimatedSizeInBytes();
                logger.debug("Cache size after prune: {}", (Object)cacheSize);
            }
        }
    }
}

