/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.database.annotations.Nullable;
import com.google.firebase.iid.FirebaseInstanceIdException;
import com.google.firebase.internal.AbstractHttpErrorHandler;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.ErrorHandlingHttpClient;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.HttpRequestInfo;
import com.google.firebase.internal.NonNull;
import java.util.Map;

public class FirebaseInstanceId {
    private static final String IID_SERVICE_URL = "https://console.firebase.google.com/v1";
    private static final Map<Integer, String> ERROR_CODES = ImmutableMap.builder().put(400, "Malformed instance ID argument.").put(401, "Request not authorized.").put(403, "Project does not match instance ID or the client does not have sufficient privileges.").put(404, "Failed to find the instance ID.").put(409, "Already deleted.").put(429, "Request throttled out by the backend server.").put(500, "Internal server error.").put(503, "Backend servers are over capacity. Try again later.").build();
    private final FirebaseApp app;
    private final String projectId;
    private final ErrorHandlingHttpClient<FirebaseInstanceIdException> httpClient;
    private static final String SERVICE_ID = FirebaseInstanceId.class.getName();

    private FirebaseInstanceId(FirebaseApp app) {
        this(app, (HttpRequestFactory)null);
    }

    @VisibleForTesting
    FirebaseInstanceId(FirebaseApp app, @Nullable HttpRequestFactory requestFactory) {
        this.app = Preconditions.checkNotNull(app, "app must not be null");
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(projectId), "Project ID is required to access instance ID service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        this.projectId = projectId;
        if (requestFactory == null) {
            requestFactory = ApiClientUtils.newAuthorizedRequestFactory(app);
        }
        this.httpClient = new ErrorHandlingHttpClient<FirebaseInstanceIdException>(requestFactory, app.getOptions().getJsonFactory(), new InstanceIdErrorHandler());
    }

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseInstanceId getInstance(FirebaseApp app) {
        FirebaseInstanceIdService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseInstanceIdService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseInstanceIdService(app));
        }
        return (FirebaseInstanceId)service.getInstance();
    }

    @VisibleForTesting
    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.httpClient.setInterceptor(interceptor);
    }

    public void deleteInstanceId(@NonNull String instanceId) throws FirebaseInstanceIdException {
        this.deleteInstanceIdOp(instanceId).call();
    }

    public ApiFuture<Void> deleteInstanceIdAsync(@NonNull String instanceId) {
        return this.deleteInstanceIdOp(instanceId).callAsync(this.app);
    }

    private CallableOperation<Void, FirebaseInstanceIdException> deleteInstanceIdOp(final String instanceId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(instanceId), "instance ID must not be null or empty");
        return new CallableOperation<Void, FirebaseInstanceIdException>(){

            @Override
            protected Void execute() throws FirebaseInstanceIdException {
                String url = String.format("%s/project/%s/instanceId/%s", FirebaseInstanceId.IID_SERVICE_URL, FirebaseInstanceId.this.projectId, instanceId);
                HttpRequestInfo request = HttpRequestInfo.buildDeleteRequest(url);
                FirebaseInstanceId.this.httpClient.send(request);
                return null;
            }
        };
    }

    private static class FirebaseInstanceIdService
    extends FirebaseService<FirebaseInstanceId> {
        FirebaseInstanceIdService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseInstanceId(app));
        }
    }

    private static class InstanceIdErrorHandler
    extends AbstractHttpErrorHandler<FirebaseInstanceIdException> {
        private InstanceIdErrorHandler() {
        }

        @Override
        protected FirebaseInstanceIdException createException(FirebaseException base) {
            String message = base.getMessage();
            String customMessage = this.getCustomMessage(base);
            if (!Strings.isNullOrEmpty(customMessage)) {
                message = customMessage;
            }
            return new FirebaseInstanceIdException(base, message);
        }

        private String getCustomMessage(FirebaseException base) {
            IncomingHttpResponse response = base.getHttpResponse();
            if (response != null) {
                String instanceId = this.extractInstanceId(response);
                String description = (String)ERROR_CODES.get(response.getStatusCode());
                if (description != null) {
                    return String.format("Instance ID \"%s\": %s", instanceId, description);
                }
            }
            return null;
        }

        private String extractInstanceId(IncomingHttpResponse response) {
            String url = response.getRequest().getUrl();
            int index = url.lastIndexOf(47);
            return url.substring(index + 1);
        }
    }
}

