/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.core.ApiFuture;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.NonNull;
import java.util.concurrent.Callable;

public abstract class CallableOperation<T, V extends Exception>
implements Callable<T> {
    protected abstract T execute() throws V;

    @Override
    public final T call() throws V {
        return this.execute();
    }

    public final ApiFuture<T> callAsync(@NonNull FirebaseApp app) {
        Preconditions.checkNotNull(app);
        return ImplFirebaseTrampolines.submitCallable(app, this);
    }
}

