/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.RetryConfig;
import com.google.firebase.internal.RetryInitializer;
import java.io.IOException;
import java.util.List;

public final class FirebaseRequestInitializer
implements HttpRequestInitializer {
    private final List<HttpRequestInitializer> initializers;

    public FirebaseRequestInitializer(FirebaseApp app) {
        this(app, null);
    }

    public FirebaseRequestInitializer(FirebaseApp app, @Nullable RetryConfig retryConfig) {
        ImmutableCollection.Builder initializers = ((ImmutableList.Builder)ImmutableList.builder().add(new HttpCredentialsAdapter(ImplFirebaseTrampolines.getCredentials(app)))).add(new TimeoutInitializer(app.getOptions()));
        if (retryConfig != null) {
            ((ImmutableList.Builder)initializers).add(new RetryInitializer(retryConfig));
        }
        this.initializers = ((ImmutableList.Builder)initializers).build();
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        for (HttpRequestInitializer initializer : this.initializers) {
            initializer.initialize(request);
        }
    }

    private static class TimeoutInitializer
    implements HttpRequestInitializer {
        private final int connectTimeoutMillis;
        private final int readTimeoutMillis;

        TimeoutInitializer(FirebaseOptions options) {
            this.connectTimeoutMillis = options.getConnectTimeout();
            this.readTimeoutMillis = options.getReadTimeout();
        }

        @Override
        public void initialize(HttpRequest request) {
            request.setConnectTimeout(this.connectTimeoutMillis);
            request.setReadTimeout(this.readTimeoutMillis);
        }
    }
}

