/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Sleeper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.DateUtils;
import com.google.firebase.internal.RetryConfig;
import java.io.IOException;
import java.util.Date;

final class RetryUnsuccessfulResponseHandler
implements HttpUnsuccessfulResponseHandler {
    private final RetryConfig retryConfig;
    private final BackOff backOff;
    private final Sleeper sleeper;
    private final Clock clock;

    RetryUnsuccessfulResponseHandler(RetryConfig retryConfig) {
        this(retryConfig, Clock.SYSTEM);
    }

    RetryUnsuccessfulResponseHandler(RetryConfig retryConfig, Clock clock) {
        this.retryConfig = Preconditions.checkNotNull(retryConfig);
        this.backOff = retryConfig.newBackOff();
        this.sleeper = retryConfig.getSleeper();
        this.clock = Preconditions.checkNotNull(clock);
    }

    @Override
    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
        if (!supportsRetry) {
            return false;
        }
        int statusCode = response.getStatusCode();
        if (!this.retryConfig.getRetryStatusCodes().contains(statusCode)) {
            return false;
        }
        try {
            return this.waitAndRetry(response);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    RetryConfig getRetryConfig() {
        return this.retryConfig;
    }

    private boolean waitAndRetry(HttpResponse response) throws IOException, InterruptedException {
        String retryAfterHeader = response.getHeaders().getRetryAfter();
        if (!Strings.isNullOrEmpty(retryAfterHeader)) {
            long intervalMillis = this.parseRetryAfterHeaderIntoMillis(retryAfterHeader.trim());
            if (intervalMillis > (long)this.retryConfig.getMaxIntervalMillis()) {
                return false;
            }
            if (intervalMillis > 0L) {
                this.sleeper.sleep(intervalMillis);
                return true;
            }
        }
        return BackOffUtils.next(this.sleeper, this.backOff);
    }

    private long parseRetryAfterHeaderIntoMillis(String retryAfter) {
        try {
            return Long.parseLong(retryAfter) * 1000L;
        }
        catch (NumberFormatException e) {
            Date date = DateUtils.parseDate(retryAfter);
            if (date != null) {
                return date.getTime() - this.clock.currentTimeMillis();
            }
            return -1L;
        }
    }
}

