/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.Nullable;
import com.google.firebase.messaging.FirebaseMessagingException;

public final class SendResponse {
    private final String messageId;
    private final FirebaseMessagingException exception;

    private SendResponse(String messageId, FirebaseMessagingException exception) {
        this.messageId = messageId;
        this.exception = exception;
    }

    @Nullable
    public String getMessageId() {
        return this.messageId;
    }

    @Nullable
    public FirebaseMessagingException getException() {
        return this.exception;
    }

    public boolean isSuccessful() {
        return !Strings.isNullOrEmpty(this.messageId);
    }

    static SendResponse fromMessageId(String messageId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(messageId), "messageId must not be null or empty");
        return new SendResponse(messageId, null);
    }

    static SendResponse fromException(FirebaseMessagingException exception) {
        Preconditions.checkNotNull(exception, "exception must not be null");
        return new SendResponse(null, exception);
    }
}

